% Simple demo
clear all
addpath('./Manifolds3D');
addpath('Images2D');
rng('default');
NumSamples=1000;
NumHistograms=50;
LowerMargin=0;
UpperMargin=2;


disp('HT demo');
FileNumber=input('Please specify the input dataset (1=Ball, 2=ThickS, 3=ThinS, 4=ThreeBalls, 5=TwoShapes, 6=X): ');
ListFileNames={'Ball.jpg','ThickS.jpg','ThinS.jpg','ThreeBalls.jpg','TwoShapes.jpg','X.jpg'};
if ismember(FileNumber,1:numel(ListFileNames))
    FileName=ListFileNames{FileNumber};
else
    error('Invalid dataset');
end

disp('Generating training samples...')
Samples=GenerateSamplesImg(FileName,NumSamples);

disp('Building the model...')
Model=HistogramTransform(Samples,NumHistograms,LowerMargin,UpperMargin);

% Measure the performance
disp('Generating test samples...')
TestSamples=GenerateSamplesImg(FileName,10000);

disp('Measuring ANLL...')
TestDensity=TestHTMEX(Model,TestSamples);
ANLL=-(1/size(TestSamples,2))*sum(log(TestDensity))

disp('Preparing the plots...')
[X Y]=meshgrid(0:0.003:1,0:0.003:1);
TestSamplesPlot=zeros(2,numel(X));
TestSamplesPlot(1,:)=reshape(X,1,numel(X));
TestSamplesPlot(2,:)=reshape(Y,1,numel(X));

DensitiesPlot=TestHTMEX(Model,TestSamplesPlot);
fprintf('Estimated integral of the probability density in the plotted area: %f\n',sum(DensitiesPlot(:))/(334*334));
figure
imagesc(flipud(reshape(DensitiesPlot,334,334)))
hold on
title('Estimated probability density')
colormap(flipud(hot))
colorbar
axis off
