% Number of histograms demo
clear all
addpath('Images2D');
rand('twister',5489);
%warning off

LowerMargin=0;
UpperMargin=2;


disp('HT demo');
FileNumber=input('Please specify the input dataset (1=Ball, 2=ThickS, 3=ThinS, 4=ThreeBalls, 5=TwoShapes, 6=X): ');
ListFileNames={'Ball.jpg','ThickS.jpg','ThinS.jpg','ThreeBalls.jpg','TwoShapes.jpg','X.jpg'};
if ismember(FileNumber,1:numel(ListFileNames))
    FileName=ListFileNames{FileNumber};
else
    error('Invalid dataset');
end



disp('Building the models...')

ANLLmean=[];
ANLLstd=[];
Histograms=[];
MyANLL=zeros(1,100);
CntTest=1;
for NumSamples=[1000 2000 4000]
    disp('Generating training samples...')
    Samples=GenerateSamplesImg(FileName,NumSamples);

    disp('Generating test samples...')
    TestSamples=GenerateSamplesImg(FileName,NumSamples);
    
    for NumHistograms=1:100
        for NdxRun=1:100
            Model=HistogramTransform(Samples,NumHistograms,LowerMargin,UpperMargin);
            TestDensity=TestHTMEX(Model,TestSamples);
            MyANLL(NdxRun)=-(1/size(TestSamples,2))*sum(log(TestDensity));        
        end
        Histograms(NumHistograms,CntTest)=NumHistograms;
        ANLLmean(NumHistograms,CntTest)=mean(MyANLL);
        ANLLstd(NumHistograms,CntTest)=std(MyANLL);
        
    end
    CntTest=CntTest+1;
end

Handle(1)=errorbar(Histograms(:,1),ANLLmean(:,1),ANLLstd(:,1),'-r');
hold on
Handle(2)=errorbar(Histograms(:,2),ANLLmean(:,2),ANLLstd(:,2),'-b');
Handle(3)=errorbar(Histograms(:,3),ANLLmean(:,3),ANLLstd(:,3),'-b','Color',[0 0.5 0]);
axis([0 100 -1.5 -0.7])
xlabel('H')
ylabel('ANLL')
legend(Handle,'N=1000','N=2000','N=4000','NorthEast');


