% Number of samples demo
clear all
addpath('Images2D');
rng('default');

NumHistograms=50;
LowerMargin=0;
UpperMargin=2;


disp('HT demo');
FileNumber=input('Please specify the input dataset (1=Ball, 2=ThickS, 3=ThinS, 4=ThreeBalls, 5=TwoShapes, 6=X): ');
ListFileNames={'Ball.jpg','ThickS.jpg','ThinS.jpg','ThreeBalls.jpg','TwoShapes.jpg','X.jpg'};
if ismember(FileNumber,1:numel(ListFileNames))
    FileName=ListFileNames{FileNumber};
else
    error('Invalid dataset');
end


disp('Generating test samples...')
TestSamples=GenerateSamplesImg(FileName,10000);

disp('Building the models...')
CntTest=1;
ANLL=[];
NumSamples=[];
CPUtime=[];
for MyNumSamples=1000:1000:10000
    Samples=GenerateSamplesImg(FileName,MyNumSamples);
    tic
    Model{CntTest}=HistogramTransform(Samples,NumHistograms,LowerMargin,UpperMargin);
    CPUtime(CntTest)=toc;
    TestDensity=TestHTMEX(Model{CntTest},TestSamples);
    ANLL(CntTest)=-(1/size(TestSamples,2))*sum(log(TestDensity));
    NumSamples(CntTest)=MyNumSamples;
    CntTest=CntTest+1;
end

plot(NumSamples,ANLL,'-b');
hold on
xlabel('N')
ylabel('ANLL')
hold off
figure
plot(NumSamples,CPUtime,'-r');
hold on
xlabel('N')
ylabel('CPU time')
hold off