function [A b Volume]=GenerateRandomAffineTransform(GlobalCovarianceMatrix,NumSamples,LowerMargin,UpperMargin)
% Generate a random affine transform
% Coded by Ezequiel Lopez-Rubio. November 2013.
% Inputs:
%   GlobalCovarianceMatrix      Covariance matrix of the training set
%   NumSamples                  Number of samples of the training set
%   LowerMargin                 Lower scale parameter theta_min
%   UpperMargin                 Upper scale parameter theta_max

% Get the input space dimension
Dimension=size(GlobalCovarianceMatrix,1);

% Generate a random translation uniformly
b=rand(Dimension,1);

% Generate a random rotation uniformly
[Q,R]=qr(randn(Dimension));
Q=Q*diag(sign(diag(R)));
if det(Q)<0
    Q(:,1)=-Q(:,1);
end

% Compute optimal bin width for a multivariate normal according to page 67
% of:
% Scott, D.W. (1992). Multivariate Density Estimation.
LogOptimalBinWidth=log(3.5)+0.5*log(trace(GlobalCovarianceMatrix)/Dimension) ...
    -(1/(Dimension+2))*log(NumSamples);
% The optimal scale is the inverse of the optimal bin width
LogOptimalScale=-LogOptimalBinWidth;
% Compute the lower and upper limits for random scale generation
LowerLimit=LogOptimalScale+LowerMargin;
UpperLimit=LogOptimalScale+UpperMargin;
Range=UpperLimit-LowerLimit;

% Generate a random scaling matrix uniformly
Lambda=diag(exp(LowerLimit+Range*rand(Dimension,1)));

% Compute the transformation matrix and the bin volume
A=Q*Lambda;
Volume=1/prod(diag(Lambda));





