function [Model]=HistogramTransform(Samples,NumHistograms,LowerMargin,UpperMargin)
% Discrete Histogram Transform
% Coded by Ezequiel Lopez-Rubio. November 2013.
% Inputs:
%   Samples         DxN matrix with N training samples of dimension D
%   NumHistograms   Number of histograms parameter H
%   LowerMargin     Lower scale parameter theta_min
%   UpperMargin     Upper scale parameter theta_max
% Outputs:
%   Model           Resulting DHT model

% Get input sizes
[Dimension NumSamples]=size(Samples);

% Swap margins if they are not correct
if UpperMargin<LowerMargin
    Auxiliary=LowerMargin;
    LowerMargin=UpperMargin;
    UpperMargin=Auxiliary;
end

% Initialize model
Model.LowerMargin=LowerMargin;
Model.UpperMargin=UpperMargin;
Model.Dimension=Dimension;
Model.NumSamples=NumSamples;
Model.NumHistograms=NumHistograms;
Model.GlobalCovarianceMatrix=cov(Samples');
Model.InvGlobalCovarianceMatrix=inv(Model.GlobalCovarianceMatrix);
Model.GlobalMean=mean(Samples,2);
Model.GaussianConstant=exp(-0.5*Dimension*log(2*pi)-0.5*log(det(Model.GlobalCovarianceMatrix)));
Model.A=zeros(Dimension,Dimension,NumHistograms);
Model.b=zeros(Dimension,NumHistograms);
Model.VolumeBin=zeros(1,NumHistograms);

% Compute the histograms
for NdxHistogram=1:NumHistograms
    [A b Volume]=GenerateRandomAffineTransform(Model.GlobalCovarianceMatrix,NumSamples,LowerMargin,UpperMargin);
    Model.Histogram{NdxHistogram}=ComputeHistogramMEX(Samples,A,b);    
    Model.A(:,:,NdxHistogram)=A;
    Model.b(:,NdxHistogram)=b;
    Model.VolumeBin(NdxHistogram)=Volume;
end
