% Demo with irregular shape, unequal scaling 0.01 and 0.02 and 1% outliers. 
% German-McClure, Welsch and Tukey fail to unfold. L2 sends some neurons to the outlying region, due to its lack of
% robustness.

clear all
close all

NumSamples=10000;
NumRowsMap=8;
NumColsMap=8;
NumSteps=20000;
FileName='Irregular.bmp';

InputSamples=GenerateSamplesImg(FileName,0.99*NumSamples);
InputSamples(1,:)=0.01*InputSamples(1,:);
InputSamples(2,:)=0.02*InputSamples(2,:);
InputSamples=[InputSamples, -0.1+0.2*rand(2,0.01*NumSamples)]; % Add the outliers

Types={'L2','L1','L1-L2','Lp','Fair','Huber','Cauchy','German-McClure','Welsch','Tukey'};

Handle=zeros(numel(Types),1);
for NdxType=1:numel(Types)
    Model=TrainMESOM(InputSamples,Types{NdxType},NumRowsMap,NumColsMap,NumSteps);

    Handle(NdxType)=PlotMESOM(Model);

    hold on
    title(Types{NdxType});
    h=plot(InputSamples(1,:),InputSamples(2,:),'yx','Color',[1 1 0.5],'LineWidth',1);
    uistack(h,'bottom')
    axis([0 0.01 0 0.02]);
    hold off
    
    
    
end
