% Demo with unequal scaling 0.01 and 0.02. German-McClure, Welsch and Tukey tend
% to unfold incorrectly.

clear all
close all

InputSamples=[0.01*rand(1,10000); 0.02*rand(1,10000)];
NumRowsMap=7;
NumColsMap=8;
NumSteps=20000;
Types={'L2','L1','L1-L2','Lp','Fair','Huber','Cauchy','German-McClure','Welsch','Tukey'};

Handle=zeros(numel(Types),1);
for NdxType=1:numel(Types)
    Model=TrainMESOM(InputSamples,Types{NdxType},NumRowsMap,NumColsMap,NumSteps);

    Handle(NdxType)=PlotMESOM(Model);

    hold on
    title(Types{NdxType});
    h=plot(InputSamples(1,:),InputSamples(2,:),'yx','Color',[1 1 0.5],'LineWidth',1);
    uistack(h,'bottom')
    hold off

  
end