% Demo of multispectral image visualization (without outliers)
% German-McClure, Welsch and Tukey fail to unfold adequately.

clear all
close all


NumRowsMap=8;
NumColsMap=8;
NumSteps=100000;
NumRowsImg=512;
NumColsImg=512;

load('Statue.mat','Samples');

Types={'L2','L1','L1-L2','Lp','Fair','Huber','Cauchy','German-McClure','Welsch','Tukey'};

Handle=zeros(numel(Types),1);
imshow(reshape(Samples(1:3,:)',[512 512 3]));
hold on
title('Original (3 first channels out of 31)');
hold off

for NdxType=1:numel(Types)
    Model=TrainMESOM(Samples,Types{NdxType},NumRowsMap,NumColsMap,NumSteps);

    OutputImage=VisualizeMultispectralImage(Model,Samples,NumRowsImg,NumColsImg);    
    figure
    imshow(OutputImage);
    hold on
    title(Types{NdxType});
    hold off
    
end
