% Demo of multispectral image visualization (with 5% outliers).
% L2 sends some neurons to the outlying region, and this is the cause that
% the L2 visualization has a narrow range of colors and poor rendering
% of the background features (the missing colors
% are associated to neurons in the outlying region where few samples
% exist). German-McClure, Welsch and Tukey fail to unfold adequately.

clear all
close all


NumRowsMap=8;
NumColsMap=8;
NumSteps=100000;
NumRowsImg=512;
NumColsImg=512;


load('Statue.mat','Samples');
NumChannels=size(Samples,1);
NumPixels=NumRowsImg*NumColsImg;
NumOutliers=ceil(0.05*NumPixels);
OutlierPixelIndices=ceil(NumRowsImg*NumColsImg*rand(NumOutliers,1));
Samples(:,OutlierPixelIndices)=rand(NumChannels,NumOutliers);

Types={'L2','L1','L1-L2','Lp','Fair','Huber','Cauchy','German-McClure','Welsch','Tukey'};

Handle=zeros(numel(Types),1);
imshow(reshape(Samples(1:3,:)',[512 512 3]));
hold on
title('Original (3 first channels out of 31)');
hold off

for NdxType=1:numel(Types)
    Model=TrainMESOM(Samples,Types{NdxType},NumRowsMap,NumColsMap,NumSteps);

    OutputImage=VisualizeMultispectralImage(Model,Samples,NumRowsImg,NumColsImg);    
    figure
    imshow(OutputImage);
    hold on
    title(Types{NdxType});
    hold off
    
end
