function [Handle]=PlotMESOM(Model)
% Plot a M-estimator Self Organizing Map over a bidimensional input space
% Inputs:
% Model=Map to be drawn


NumRowsMap=Model.NumRowsMap;
NumColsMap=Model.NumColsMap;
Prototypes=Model.Prototypes;


Handle=figure;
hold on

% Draw the horizontal connections
for NdxRow=1:NumRowsMap
    for NdxCol=1:(NumColsMap-1)
        LineX=[Prototypes(1,NdxRow,NdxCol) Prototypes(1,NdxRow,NdxCol+1)];
        LineY=[Prototypes(2,NdxRow,NdxCol) Prototypes(2,NdxRow,NdxCol+1)];        
        plot(LineX,LineY,'-b','LineWidth',1);
    end
end

% Draw the vertical connections
for NdxRow=1:(NumRowsMap-1)
    for NdxCol=1:NumColsMap
        LineX=[Prototypes(1,NdxRow,NdxCol) Prototypes(1,NdxRow+1,NdxCol)];
        LineY=[Prototypes(2,NdxRow,NdxCol) Prototypes(2,NdxRow+1,NdxCol)];        
        plot(LineX,LineY,'-b','LineWidth',1);
    end
end

% Draw the neurons
for NdxRow=1:NumRowsMap
    for NdxCol=1:NumColsMap
        CircleX=Prototypes(1,NdxRow,NdxCol);
        CircleY=Prototypes(2,NdxRow,NdxCol);        
        h=plot(CircleX,CircleY,'or','LineWidth',1,'MarkerFaceColor',[1 0 0]);
    end
end


