function [OutputImage]=VisualizeMultispectralImage(Model,MultiImage,NumRowsImg,NumColsImg)
% Visualize a multispectral image with a MESOM

PaletteCIELAB=zeros(Model.NumRowsMap,Model.NumColsMap,3);
PaletteCIELAB(:,:,1)=75;
StepRows=256/(Model.NumRowsMap-1);
StepCols=256/(Model.NumColsMap-1);
[a b]=ndgrid(-128:StepRows:128,-128:StepCols:128);
PaletteCIELAB(:,:,2)=a;
PaletteCIELAB(:,:,3)=b;

PaletteRGB=permute(colorspace('Lab->RGB',PaletteCIELAB),[3 1 2]);

Winners=CompetitionMESOM(Model,MultiImage);

OutputImage=reshape(PaletteRGB(:,Winners)',[NumRowsImg NumColsImg 3]);


