% Demo of MMED (distribution families)
clear all
NumSamples=100;
Dimension=40;

% Generate samples from the uniform distribution
Samples=rand(Dimension,NumSamples);
SamplesTest=zeros(Dimension,300);
SamplesTest(Dimension,1:399)=0.005:0.1:39.9;


NumGroups=1;
NumUnitsPerGroup=78;

NumSteps=0;

Model.Samples=Samples;
Model.NumGroups=1;
Model.NumUnitsPerGroup=78;
Model.NumParameters=1;
Model.Pi=(1/(Model.NumGroups*Model.NumUnitsPerGroup))*ones(Model.NumUnitsPerGroup,Model.NumGroups);
Model.Means{1}=zeros(Dimension,1);
Model.C{1}=eye(Dimension);
Model.CInv{1}=eye(Dimension);

for NdxUnit=18:-1:1
    Model.Pi=zeros(78,1);
    Model.Pi(NdxUnit)=1;
    [ANLL,LogProbDensities,ResponsibilitiesUnits,ResponsibilitiesGroups,DistMahal] = MMEDANLLMEX(SamplesTest,Model);
    switch NdxUnit
        case 1
            % Gaussian
            MyColor=[0 0 0];
        case 2
            % Exponential square root (undefined for D=1)
            MyColor=[0 0.8 0.8];
        case 3
            % Multivariate Laplacian (not computed for D<6)
            MyColor=[0.8 0.8 0];
        otherwise
            switch mod(NdxUnit-3,3)
                case 0
                    % Triangular
                    MyColor=[0 0.7 0];
                case 1
                    % Student-t
                    MyColor=[0 0 1];
                case 2
                    % Uniform
                    MyColor=[1 0 0];
            end
    end
    Handle(NdxUnit)=semilogy(0.005:0.1:39.9,exp(LogProbDensities),'Color',MyColor);
    hold on
    axis([0 10 1.0e-40 1.0e30])
    Densities{NdxUnit}=exp(LogProbDensities);
    % Approximation of the integral of the probability density. It should yield approximately 1
    if Dimension==1        
        sum(Densities{NdxUnit}(find(isfinite(Densities{NdxUnit}))))/100
    end
end
xlabel('Mahalanobis distance r')
ylabel('Probability density p(r)')
legend(Handle([1 2 3 4 5 6]),'Gaussian','ExpSqrRoot','Laplacian','Student-t','Uniform','Triangular');


