function [PrunedModel]=PruneHistMMED(Model,Constants,Limits)
% Prune a MMED model by the histogram analysis method
% Inputs:
%   Model=MMED model to be pruned
%   Constants=Constants for histogram analysis (see PrecomputeConstants.m)
%   Limits=Limits of the bins for the histogram analysis (see PrecomputeConstants.m)
% Outputs:
%	PrunedModel=Pruned MMED model

Dimension=size(Model.Samples,1);
NumBins=numel(Limits)-1;
ModelOrig=Model;

% See the Mahalanobis distances and the responsibilities of the groups
[ANLL,LogProbDensities,ResponsibilitiesUnits,ResponsibilitiesGroups,DistMahal] = MMEDANLLMEX(Model.Samples,Model);

% Ver responsabilidades de los grupos
ResponsibilitiesGroups(find(~isfinite(ResponsibilitiesGroups)))=0;
TotalRespGroups=sum(ResponsibilitiesGroups,2);
TotalRespGroups=TotalRespGroups/sum(TotalRespGroups);

% Adjust the weights of the units of each group
for NdxGroup=1:Model.NumGroups
    MyRespon=ResponsibilitiesGroups(NdxGroup,:);
    MyMahalDist=sqrt(DistMahal(NdxGroup,:));
    for NdxBin=1:NumBins
        NdxMySamples=find( (MyMahalDist>=Limits(NdxBin)) & (MyMahalDist<=Limits(NdxBin+1)) );
        Histogram(NdxBin)=sum(MyRespon(NdxMySamples));
    end
    if sum(Histogram)>0
        Histogram=Histogram/sum(Histogram);    
    else
        Histogram=[1 zeros(1,numel(Histogram)-1)];
    end
    Solution=lsqnonneg(Constants',Histogram');        
    if (sum(isfinite(Solution))==Model.NumUnitsPerGroup) && (sum(Solution)>0)
        Model.Pi(:,NdxGroup)=Solution;
    end
    % Normalize the probabilities of the group
    Model.Pi(:,NdxGroup)=Model.Pi(:,NdxGroup)/sum(Model.Pi(:,NdxGroup));
    % Adjust to the responsibility of the group
    Model.Pi(:,NdxGroup)=Model.Pi(:,NdxGroup)*TotalRespGroups(NdxGroup);
end

% See whether performance improves
[ANLLPruned,LogProbDensities,ResponsibilitiesUnits,ResponsibilitiesGroups,DistMahal] = MMEDANLLMEX(Model.Samples,Model);

if ANLLPruned<ANLL
    PrunedModel=Model;
else
    % No improvement, so we retain the old model
    PrunedModel=ModelOrig;
end
                


