function [Model2]=PruneMMED(Model,Threshold)
% Inputs:
%   Model=MMED model to be pruned
%   Threshold=Threshold for the a priori probability (if the probability is under the threshold,
%		the unit is pruned)
% Output:
%	Model2=Pruned MMED model



Dimension=numel(Model.Means{1});

Cnt=0;
for ndx=1:Model.NumGroups*Model.NumUnitsPerGroup
    if Model.Pi(ndx)<Threshold
        Model.Pi(ndx)=0;
        Cnt=Cnt+1;
    end
end

Model2.NumGroups=0;
Model2.Samples=Model.Samples;
Model2.NumUnitsPerGroup=Model.NumUnitsPerGroup;
for ndx=1:Model.NumGroups
    % See whether this GMC survives the pruning
    if sum(Model.Pi(:,ndx))>0
        Model2.NumGroups=Model2.NumGroups+1;
        Model2.Pi(:,Model2.NumGroups)=Model.Pi(:,ndx);
        Model2.Means{Model2.NumGroups}=Model.Means{ndx};
        Model2.C{Model2.NumGroups}=Model.C{ndx};
        Model2.CInv{Model2.NumGroups}=Model.CInv{ndx};   
    end
end

% Normalize a priori probabilities
Model2.Pi(:)=Model2.Pi(:)/sum(Model2.Pi(:));

% Find the new number of free parameters
NumUnits=sum(Model2.Pi(:)>0);
Model2.NumParameters=Model2.NumGroups*Dimension*(0.5*Dimension+1.5)+...
    NumUnits-1;
