function [NewModel]=AdaptPCASOM(TheSample,Model,...
   WinningRow,WinningColumn,...
      LearningRateFunc,TopologyFunc,NdxEpoch,NumEpochs)
% Adapt the network to a sample 

% By E. Lopez-Rubio, J. Muoz-Perez and J.A. Gomez-Ruiz
% School of Computer Engineering
% Campus de Teatinos, s/n
% 29071 Malaga. Spain.
% From the paper 'A Principal Components Analysis Self-Organizing Map',
% Neural Networks 17 (2004), 261-270

% Input:
%	TheSample = Sample vector (see PCASOMCompetition.m)
%	Model = State of the network (see pcasom.m)
%	WinningRow,WinningColumn = coordinates of the winning neuron on the self-organizing map
%	LearningRateFunc = Given the index of the epoch and the total number of epochs,
%			this function returns the learning rate for that epoch
%	TopologyFunc = Given the index of the epoch, the total number of epochs and the
%			lateral distance from a neuron to the winning neuron, this function
%			returns the topologic neighbourhood coefficient for that neuron. It must
%			hold that feval(TopologyFunc,a,b,0)==1 for all a and b.
%	NdxEpoch = Index of the current epoch
%	NumEpochs = Total number of epochs to run
% Output:
%	NewModel = New state of the network



% Learning rate for this epoch
LearningRate=feval(LearningRateFunc,NdxEpoch,NumEpochs);


% For each neuron in the network
for ThisNeuronRow=1:Model.GridRows
	for ThisNeuronColumn=1:Model.GridCols
   	   % Compute the topological distante to the winning neuron
	   Delta=[ThisNeuronRow-WinningRow ...
   		ThisNeuronColumn-WinningColumn];
		Topology=feval(TopologyFunc,NdxEpoch,NumEpochs,Model.GridRows,Model.GridCols,Delta);
		ChangeCoefficient=Topology*LearningRate;               
        % Modify the mean vector estimation
        Model.Means{ThisNeuronRow,ThisNeuronColumn}=(1-ChangeCoefficient)*...
            Model.Means{ThisNeuronRow,ThisNeuronColumn}+...
            ChangeCoefficient*TheSample;
      % Modify the correlation matrix estimation
      ZeroMeanVector=TheSample-Model.Means{ThisNeuronRow,ThisNeuronColumn};
      Model.Covariances{ThisNeuronRow,ThisNeuronColumn}=(1-ChangeCoefficient)*...
         Model.Covariances{ThisNeuronRow,ThisNeuronColumn}+...
         ChangeCoefficient*ZeroMeanVector*ZeroMeanVector';
      
   end      
end         


NewModel=Model;

