function [TheSample]=ChooseSampleSimple(NdxEpoch,Samples)
% Function to extract a sample from the sample matrix, where we suppose
%	that each column of the sample matrix is an independent sample

% By E. Lopez-Rubio, J. Muoz-Perez and J.A. Gomez-Ruiz
% School of Computer Engineering
% Campus de Teatinos, s/n
% 29071 Malaga. Spain.
% From the paper 'A Principal Components Analysis Self-Organizing Map',
% Neural Networks 17 (2004), 261-270

% Input:
%	NdxEpoch = Index of the current epoch
%	Samples = Matrix whose columns are samples
% Output:
%	TheSample = Selected sample



% Find the total number of samples
[Dimension,TotalSamples]=size(Samples);

TheSample=zeros(Dimension,1);

% Choose a sample
MyNdx=rem(ceil(100000*rand(1)),TotalSamples)+1;

% Return the chosen sample
TheSample=Samples(:,MyNdx);

