function [AbsoluteErrors,RelativeErrors]=ComputeErrorPCASOM(Model,Samples)
% Compute the projection error of a PCASOM network with respect to the specified sample vectors

% By E. Lopez-Rubio, J. Muoz-Perez and J.A. Gomez-Ruiz
% School of Computer Engineering
% Campus de Teatinos, s/n
% 29071 Malaga. Spain.
% From the paper 'A Principal Components Analysis Self-Organizing Map',
% Neural Networks 17 (2004), 261-270

% Input:
%	Model= network state (see pcasom.m)
%	NumBasisVectors=Number of vectors of each vector basis
%	Samples=Each column of this matrix is a sample
% Output:
%	AbsoluteErrors=Absolute errors (norms of the projection error vector)
%	RelativeErrors=Relative errors (quotients between the error vector norm
%			and the sample norm)

[Dimension,NumSamples]=size(Samples);


AbsoluteErrors=[];
RelativeErrors=[];
for ndx=1:NumSamples
   MyVector=Samples(:,ndx);
   [WinningRow,WinningColumn]=PCASOMCompetition(MyVector,Model);
   % Find the difference with the mean vector of this neuron
   MyDiff=MyVector-Model.Means{WinningRow,WinningColumn};
   % Compute the projection
   Projection=Model.BasisVectors{WinningRow,WinningColumn}*...
      (Model.BasisVectors{WinningRow,WinningColumn}'*MyDiff);
   % Compute the error
   ErrorVector=MyDiff-Projection;
   % Store error data
   AbsoluteErrors(end+1)=norm(ErrorVector);
   RelativeErrors(end+1)=norm(ErrorVector)/norm(MyVector);
end;


   