function [Topology]=GaussTopology(NdxEpoch,NumEpochs,GridRows,GridCols,Delta)
% Gaussian topology function

% By E. Lopez-Rubio, J. Muoz-Perez and J.A. Gomez-Ruiz
% School of Computer Engineering
% Campus de Teatinos, s/n
% 29071 Malaga. Spain.
% From the paper 'A Principal Components Analysis Self-Organizing Map',
% Neural Networks 17 (2004), 261-270

% Input:
%	NdxEpoch = Index of the current epoch
%	NumEpochs = Total number of epochs to run
%   GridRows,GridCols = size of the map
%	Delta = Topological distance vector between a neuron and the winning neuron
% Output:
%	Topology = How much the neuron must learn

MaxDistance=norm([GridRows GridCols]);
LateralDistance=norm(Delta);
ConvergenceNdx=NumEpochs/2; % Convergence phase start
if NdxEpoch>ConvergenceNdx
   Sigma=0.5; % Convergence phase
else   
   MyRatio=1-NdxEpoch/ConvergenceNdx;
   Sigma=0.5+(MaxDistance-0.5)*MyRatio; % Ordering phase
end
Topology=exp(-LateralDistance^2/Sigma);
   
   
