function [PackedImage]=ImageReductionPCASOM(Model,MyImage)
% Dimensionality reduction example

% By E. Lopez-Rubio, J. Muoz-Perez and J.A. Gomez-Ruiz
% School of Computer Engineering
% Campus de Teatinos, s/n
% 29071 Malaga. Spain.
% From the paper 'A Principal Components Analysis Self-Organizing Map',
% Neural Networks 17 (2004), 261-270

% Input:
%	Model= network state (see pcasom.m)
%   MyImage=Original RGB image
% Output:
%   PackedImage=Image with only 1 component per pixel



for ndx1=1:size(MyImage,1)
    for ndx2=1:size(MyImage,2)
        MyVector=double(reshape(MyImage(ndx1,ndx2,:),3,1));
        [WinningRow,WinningColumn]=PCASOMCompetition(MyVector,Model);
        % Find the difference with the mean vector of this neuron
        MyDiff=MyVector-Model.Means{WinningRow,WinningColumn};
        % Compute the projection
        Projection=Model.BasisVectors{WinningRow,WinningColumn}*...
            (Model.BasisVectors{WinningRow,WinningColumn}'*MyDiff);
        PackedImage(ndx1,ndx2,:)=reshape(Model.Means{WinningRow,WinningColumn}+Projection,1,1,3);
    end
end


   