function [LearningRate]=LinearLearningRate(NdxEpoch,NumEpochs)
% Learning rate computation (ordering phase: linear decay, convergence phase: constant)

% By E. Lopez-Rubio, J. Muoz-Perez and J.A. Gomez-Ruiz
% School of Computer Engineering
% Campus de Teatinos, s/n
% 29071 Malaga. Spain.
% From the paper 'A Principal Components Analysis Self-Organizing Map',
% Neural Networks 17 (2004), 261-270

% Input:
%	NdxEpoch = Index of the current epoch
%	NumEpochs = Total number of epochs to run
% Output:
%	LearningRate = Learning rate for this epoch

ConvergenceNdx=NumEpochs/2; % Convergence phase start

if NdxEpoch>ConvergenceNdx
   LearningRate=0.02*ConvergenceNdx/NdxEpoch; % Convergence phase
else   
   MyRatio=1-NdxEpoch/ConvergenceNdx;
   LearningRate=0.02+(0.9-0.02)*MyRatio; % Ordering phase
end;

