function [WinningRow,WinningColumn]=PCASOMCompetition(TheSample,Model)
% Search the winning neuron for the PCASOM algorithm

% By E. Lopez-Rubio, J. Muoz-Perez and J.A. Gomez-Ruiz
% School of Computer Engineering
% Campus de Teatinos, s/n
% 29071 Malaga. Spain.
% From the paper 'A Principal Components Analysis Self-Organizing Map',
% Neural Networks 17 (2004), 261-270

% Input:
%	TheSample = Sample vector
%	Model= Current state of the network (see pcasom.m)
% Output:
%	WinningRow,WinningColumn = coordinates of the winning neuron on the self-organizing map

% Compute the dimension of the vector space
[Dimension]=length(TheSample);


% Initialize the value to be minimized
WinningValue=Inf;

% Perform the competition
for ThisNeuronRow=1:Model.GridRows
   for ThisNeuronColumn=1:Model.GridCols    
      % Find the difference with the mean vector of this neuron
      MyDiff=TheSample-Model.Means{ThisNeuronRow,ThisNeuronColumn};
      % Compute the projection
      Projection=Model.BasisVectors{ThisNeuronRow,ThisNeuronColumn}*...
          (Model.BasisVectors{ThisNeuronRow,ThisNeuronColumn}'*MyDiff);
      MyValue=norm(MyDiff-Projection)^2;
  
      % See if it is better than the past neurons
      if WinningValue>MyValue
         WinningValue=MyValue;
         WinningRow=ThisNeuronRow;
         WinningColumn=ThisNeuronColumn;
      end
   end
end