% PCASOM demo (dimensionality reduction)

% By E. Lopez-Rubio, J. Muoz-Perez and J.A. Gomez-Ruiz
% School of Computer Engineering
% Campus de Teatinos, s/n
% 29071 Malaga. Spain.
% From the paper 'A Principal Components Analysis Self-Organizing Map',
% Neural Networks 17 (2004), 261-270


clear all
Samples=double(imread('peppers.png'));
Samples=reshape(Samples,size(Samples,1)*size(Samples,2),size(Samples,3))';


GridRows=4; 
GridCols=4;
NumBasisVectors=1;
NumEpochs=200000;
BatchSize=50;


Model=pcasom(Samples,GridRows,GridCols,...
   NumBasisVectors,'LinearLearningRate','GaussTopology','ChooseSampleSimple',NumEpochs,...
   BatchSize,'AdaptPCASOM');

MyImage=imread('peppers.png');
PackedImage=ImageReductionPCASOM(Model,MyImage);

%imshow(MyImage)
%figure
%imshow(PackedImage/255)

[AbsoluteErrors,RelativeErrors]=ComputeErrorPCASOM(Model,Samples);


