% PCASOM demo 2 (receptive fields and projection vectors)

% By E. Lopez-Rubio, J. Muoz-Perez and J.A. Gomez-Ruiz
% School of Computer Engineering
% Campus de Teatinos, s/n
% 29071 Malaga. Spain.
% From the paper 'A Principal Components Analysis Self-Organizing Map',
% Neural Networks 17 (2004), 261-270


clear all
t=2*pi*rand(1,100000);
TrainingSamples=[cos(t); sin(t)]+0.05*rand(2,100000);


GridRows=8; 
GridCols=1;
NumBasisVectors=1;
NumEpochs=200000;
BatchSize=50;


Model=pcasom(TrainingSamples,GridRows,GridCols,...
   NumBasisVectors,'LinearLearningRate','GaussTopology','ChooseSampleSimple',NumEpochs,...
   BatchSize,'AdaptPCASOM');

Handle=PlotPCASOM2D(Model,30);
axis([-1.2 1.2 -1.2 1.2])

t=2*pi*rand(1,10000);
TestSamples=[cos(t); sin(t)]+0.05*rand(2,10000);
[AbsoluteErrors,RelativeErrors,ProjVectors]=TestPCASOM(Model,TestSamples);

[Minima Indexes]=min(AbsoluteErrors);
MyColors=hsv(GridRows*GridCols);
figure
hold on
for NdxUnit=1:GridRows*GridCols
    NdxColor=mod(17*NdxUnit,GridRows*GridCols)+1;
    plot(TestSamples(1,find(Indexes==NdxUnit)),TestSamples(2,find(Indexes==NdxUnit)),'xg',...
        'Color',MyColors(NdxColor,:));
end
title('Receptive fields')
axis([-1.2 1.2 -1.2 1.2])

figure
hold on
for NdxUnit=1:GridRows*GridCols
    NdxColor=mod(17*NdxUnit,GridRows*GridCols)+1;
    plot(squeeze(ProjVectors(1,NdxUnit,find(Indexes==NdxUnit))),squeeze(ProjVectors(2,NdxUnit,find(Indexes==NdxUnit))),'xg',...
        'Color',MyColors(NdxColor,:));
end
title('Projection vectors for each receptive field')
axis([-1.2 1.2 -1.2 1.2])

