function [AbsoluteErrors,RelativeErrors,Projections]=TestPCASOM(Model,Samples)
% Compute the projection error of a PCASOM network with respect to the specified sample vectors

% By E. Lopez-Rubio, J. Muoz-Perez and J.A. Gomez-Ruiz
% School of Computer Engineering
% Campus de Teatinos, s/n
% 29071 Malaga. Spain.
% From the paper 'A Principal Components Analysis Self-Organizing Map',
% Neural Networks 17 (2004), 261-270

% Input:
%	Model= network state (see pcasom.m)
%	Samples=Each column of this matrix is a sample
% Output:
%   Projections=Projection vectors
%	AbsoluteErrors=Absolute errors (norms of the projection error vector)
%	RelativeErrors=Relative errors (quotients between the error vector norm
%			and the sample norm)

[Dimension,NumSamples]=size(Samples);
Projections=zeros(Dimension,Model.GridRows*Model.GridCols,NumSamples);
AbsoluteErrors=zeros(Model.GridRows*Model.GridCols,NumSamples);
RelativeErrors=zeros(Model.GridRows*Model.GridCols,NumSamples);

for NdxSample=1:NumSamples
   TheSample=Samples(:,NdxSample);
   for NdxUnit=1:Model.GridRows*Model.GridCols
       % Find the difference with the mean vector of this neuron
        MyDiff=TheSample-Model.Means{NdxUnit};
        % Compute the projection
        Projections(:,NdxUnit,NdxSample)=Model.Means{NdxUnit}+...
            Model.BasisVectors{NdxUnit}*...
            (Model.BasisVectors{NdxUnit}'*MyDiff);
        % Compute the error
        ErrorVector=TheSample-reshape(Projections(:,NdxUnit,NdxSample),Dimension,1);
        % Store error data
        AbsoluteErrors(NdxUnit,NdxSample)=norm(ErrorVector);
        RelativeErrors(NdxUnit,NdxSample)=norm(ErrorVector)/norm(TheSample);
   end
end


   