function [Handle]=PlotPPCASOM2D(Model,NumPoints)
% Plot a PPCASOM on a bidimensional input space
% Inputs:
%   Model=Map to be drawn
%   NumPoints=Number of vertices to approximate unit Mahalanobis distance
%       ellipses

     
Handle=figure
hold on

% Plot the neurons
for NdxFila=1:Model.NumRowsMap
    for NdxCol=1:Model.NumColsMap
        C=Model.Sigma2{NdxFila,NdxCol}*eye(2)+Model.W{NdxFila,NdxCol}*Model.W{NdxFila,NdxCol}';
        PlotNeuron(Model.Means{NdxFila,NdxCol},C,1,NumPoints);
    end
end

% Plot horizontal connections
for NdxFila=1:Model.NumRowsMap
    for NdxCol=1:(Model.NumColsMap-1)
        LineX=[Model.Means{NdxFila,NdxCol}(1) Model.Means{NdxFila,NdxCol+1}(1)];
        LineY=[Model.Means{NdxFila,NdxCol}(2) Model.Means{NdxFila,NdxCol+1}(2)];        
        plot(LineX,LineY,'-b','LineWidth',1);
    end
end

% Plot vertica connections
for NdxFila=1:(Model.NumRowsMap-1)
    for NdxCol=1:Model.NumColsMap
        LineX=[Model.Means{NdxFila,NdxCol}(1) Model.Means{NdxFila+1,NdxCol}(1)];
        LineY=[Model.Means{NdxFila,NdxCol}(2) Model.Means{NdxFila+1,NdxCol}(2)];        
        plot(LineX,LineY,'-b','LineWidth',1);
    end
end


function [Result]=PlotNeuron(MyMean,MyC,Color,NumPoints)

theta = (0:1:NumPoints-1)/(NumPoints-1)*2*pi;
    
epoints = sqrtm(MyC) * [cos(theta); sin(theta)]*1   + MyMean*ones(1,NumPoints);
    
colourset = ['r'; 'g'; 'b'; 'y'; 'm'; 'c']; 
colour = colourset(mod(Color-1,size(colourset,1))+1,:);

hold on
hh = plot(epoints(1,:),epoints(2,:),colour,'LineWidth',1);

