function [Handle]=PlotPPCASOMImage(Model,Parameter)
% Plot the PPCASOM when the data are images
% Inputs:
%   Model=The PPCASOM model
%   Parameter=0 : Plot the mean vectors
%   Parameter=i>0 : Plot the i-th column of Uq


Dimension=length(Model.Means{1,1});
Side=sqrt(Dimension);
Mosaic=zeros(Side*Model.NumRowsMap,Side*Model.NumColsMap);
for NdxRow=1:Model.NumRowsMap
    RangoRows=(Side*(NdxRow-1)+1):Side*NdxRow;
    for NdxCol=1:Model.NumColsMap
        RangoCols=(Side*(NdxCol-1)+1):Side*NdxCol; 
        if Parameter==0
            Mosaic(RangoRows,RangoCols)=reshape(Model.Means{NdxRow,NdxCol},...
                Side,Side)';
        else
            [Order,Indexes]=sort(Model.Lambdaq{NdxRow,NdxCol},'descend');
            Mosaic(RangoRows,RangoCols)=reshape(Model.Uq{NdxRow,NdxCol}(:,Indexes(Parameter)),...
                Side,Side)';
        end
    end
end
if Parameter>0
    Mosaic1=imadjust(Mosaic);
    Mosaic2=imadjust(-Mosaic);
    Mosaic=[];
    Mosaic(:,:,1)=reshape(Mosaic1,1,size(Mosaic1,1),size(Mosaic1,2));
    Mosaic(:,:,2)=zeros(1,size(Mosaic1,1),size(Mosaic1,2));
    Mosaic(:,:,3)=reshape(Mosaic2,1,size(Mosaic2,1),size(Mosaic2,2));    
end

Handle=imshow(Mosaic);
