% PPCASOM demo: self organization

clear all

NumRowsMap=8;
NumColsMap=8;
NumVecBasis=1;

NumPoints=40;
Vertices=[0 0 ; 0 1; 1 1; 1 0; 0 0];


NumSteps=200000;

SamplesTrain=rand(2,100000);


Model=TrainPPCASOM(SamplesTrain,NumRowsMap,NumColsMap,NumVecBasis,NumSteps);


[Handle]=PlotPPCASOM2D(Model,NumPoints);
plot(Vertices(:,1),Vertices(:,2),'-g','LineWidth',1)
title('Mean vectors and covariance matrices')
axis([-0.05 1.05 -0.05 1.05])
axis off
hold off


SamplesTest=rand(2,10000);
[ANLL,LogDensitiesProb,ProjVectors,RepresVectors,Respon] = TestPPCASOMMEX(SamplesTest,Model);

[Maxima Indexes]=max(Respon);
MyColors=hsv(NumRowsMap*NumColsMap);
figure
hold on
for NdxUnit=1:NumRowsMap*NumColsMap
    NdxColor=mod(17*NdxUnit,NumRowsMap*NumColsMap)+1;
    plot(SamplesTest(1,find(Indexes==NdxUnit)),SamplesTest(2,find(Indexes==NdxUnit)),'xg',...
        'Color',MyColors(NdxColor,:));
end
title('Receptive fields')

figure
hold on
for NdxUnit=1:NumRowsMap*NumColsMap
    NdxColor=mod(17*NdxUnit,NumRowsMap*NumColsMap)+1;
    plot(squeeze(ProjVectors(1,NdxUnit,find(Indexes==NdxUnit))),squeeze(ProjVectors(2,NdxUnit,find(Indexes==NdxUnit))),'xg',...
        'Color',MyColors(NdxColor,:));
end
title('Projection vectors for each receptive field')

