function [Handle]=PlotQDSOM(Model,Zoom,Parameter)
% Plot the QDSOM 
% Inputs:
%   Model=The QDSOM model
%   Parameter=0 : Plot the mutual information
%   Parameter=1 : Plot the intersection probabilities
%   Parameter=2 : Plot the pointwise mutual information

switch Parameter
    case 0
        Side=Model.Dimension;
        Maximum=max(max(cell2mat(Model.Mutual)));
        Coef=1/Maximum;
    case 1
        Side=Model.NumValues;
        Maximum=max(max(cell2mat(Model.Intersect)));
        Coef=1/Maximum;
    case 2
        Side=Model.NumValues;
        for NdxRow=1:Model.NumRowsMap
            for NdxCol=1:Model.NumColsMap
                Model.Pointwise{NdxRow,NdxCol}=log(Model.Intersect{NdxRow,NdxCol}./ ...
                    (Model.Marginal{NdxRow,NdxCol}'*Model.Marginal{NdxRow,NdxCol}));  
                Model.Pointwise{NdxRow,NdxCol}(find(~isfinite(Model.Pointwise{NdxRow,NdxCol})))=0;
            end
        end        
end

Mosaic=zeros(Side*Model.NumRowsMap,Side*Model.NumColsMap);
subplot(Model.NumRowsMap,Model.NumColsMap,1);
Index=1;
for NdxRow=1:Model.NumRowsMap
    RangeRows=(Side*(NdxRow-1)+1):Side*NdxRow;
    for NdxCol=1:Model.NumColsMap
        RangeCols=(Side*(NdxCol-1)+1):Side*NdxCol; 
        switch Parameter
            case 0
                Mosaic(RangeRows,RangeCols)=reshape(Model.Mutual{NdxRow,NdxCol},...
                    Side,Side)';
            case 1
                Mosaic(RangeRows,RangeCols)=reshape(Model.Intersect{NdxRow,NdxCol},...
                    Side,Side)';
            case 2
                Mosaic(RangeRows,RangeCols)=reshape(Model.Pointwise{NdxRow,NdxCol},...
                    Side,Side)';                
        end
        Handle(Index)=subplot(Model.NumRowsMap,Model.NumColsMap,Index);
        
        if Parameter<2
            imshow(Coef*Mosaic(RangeRows,RangeCols));        
            colormap(jet);
        else
            Mosaic1=imadjust(Mosaic(RangeRows,RangeCols));
            Mosaic2=imadjust(-Mosaic(RangeRows,RangeCols));
            MyMosaic(:,:,1)=reshape(Mosaic1,1,size(Mosaic1,1),size(Mosaic1,2));
            MyMosaic(:,:,2)=zeros(1,size(Mosaic1,1),size(Mosaic1,2));
            MyMosaic(:,:,3)=reshape(Mosaic2,1,size(Mosaic2,1),size(Mosaic2,2));  
            imshow(MyMosaic)
        end
        MyPosition=get(Handle(Index),'Position');
        MyPosition(3:4)=Zoom*MyPosition(3:4);
        set(Handle(Index),'Position',MyPosition);
        Index=Index+1;
    end
end

axes('Position', [0 0 1 1], 'Visible', 'off');

if Parameter<2
    if Parameter==0
        MyTick=Coef*[0.01 0.25 0.5 0.75 1 1.25 1.5]*255;
        MyLabel={'0','0.25','0.5','0.75','1','1.25','1.5'};
    else
        MyTick=Coef*[0.01 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1]*255;
        MyLabel={'0','0.1','0.2','0.3','0.4','0.5','0.6','0.7','0.8','0.9','1'};
    end
    HandleC=colorbar ('SouthOutside','FontSize',12,'XTick',MyTick,'XTickLabel',MyLabel);
    set(HandleC,'Position',[0.25 0.05 0.5 0.05]);
end

