function [Handle]=PlotTreeQDSOMImage(Model,NodeSize)
% Plot the QDSOM spanning trees
% Inputs:
%   Model=The QDSOM model
%   NodeSize=size of nodes


ColorPalette=[1 1 0.1
   1 0.1 1
   0.1 1 1
   1 0.1 0.1
   0.1 1 0.1
   0.1 0.1 1   
   0.5 0.5 0
   0.5 0 1
   1 0.5 0
   0.1 0.7 1
   1 0.7 0.1
   0.25 0 0.25
   1 0.5 1
   0 0.5 0
   0.7 1 0.1
   0.7 0.7 0.7
   0.25 0.5 0.5];

subplot(Model.NumRowsMap,Model.NumColsMap,1);
Index=1;
for NdxRow=1:Model.NumRowsMap
    for NdxCol=1:Model.NumColsMap
        for NdxVar=1:Model.Dimension
            NdxParent=find(Model.Graph{NdxRow,NdxCol}(:,NdxVar));
            if isempty(NdxParent)
                Parents(NdxVar)=0;
            else
                Parents(NdxVar)=NdxParent;
            end
        end
        
        Handle(Index)=subplot(Model.NumRowsMap,Model.NumColsMap,Index);
        [XCoord YCoord]=treelayout(Parents);
        for NdxVar=1:Model.Dimension
            if Parents(NdxVar)>0
                line([XCoord(NdxVar) XCoord(Parents(NdxVar))],[YCoord(NdxVar) YCoord(Parents(NdxVar))],...
                    'Color',[0 0 0]);
                hold on
            end
        end
        for NdxVar=1:Model.Dimension
            rectangle('Curvature',[1 1],'Position',[XCoord(NdxVar)-0.5*NodeSize, YCoord(NdxVar)-0.5*NodeSize, ...
                NodeSize, NodeSize],'EdgeColor',[0 0 0],'FaceColor',ColorPalette(NdxVar,:));            
        end        
        axis off
          
        Index=Index+1;
    end
end

