% QDSOM demo: testing discrete distribution approximation

clear all


NumRowsMap=5;
NumColsMap=6;

% Set RootNode==0 for undirected models
RootNode=1;

NumSteps=10000;



load('Car.mat');
Ranges=max(Database.Samples')+1;
SamplesTrain=Database.Samples;
SamplesTest=Database.Samples;


Model=TrainQDSOM(SamplesTrain,Ranges,NumRowsMap,NumColsMap,NumSteps,RootNode);


Winners = WinnerQDSOMMEX(Model,SamplesTest);

[ANLL,LogLikelihoods] = QDSOMANLLMEX(Model,SamplesTest);



% Checking whether the likelihoods sum up to one (only for 7-D databases,
% e.g., the Car database)
for NdxSample=1:prod(Ranges)
    [SamplesComplete(1,NdxSample),SamplesComplete(2,NdxSample),SamplesComplete(3,NdxSample),...
        SamplesComplete(4,NdxSample),SamplesComplete(5,NdxSample),SamplesComplete(6,NdxSample),...
        SamplesComplete(7,NdxSample)]=ind2sub(Ranges,NdxSample);
end
SamplesComplete=SamplesComplete-1;
[ANLL,LogLikelihoodsComplete] = QDSOMANLLMEX(Model,SamplesComplete);
disp(sprintf('Sum of probabilities: %f',sum(exp(LogLikelihoodsComplete))))


