% QDSOM demo: self organization

clear all


NumRowsMap=5;
NumColsMap=6;

% Set RootNode==0 for undirected models
RootNode=0;

NumSteps=10000;



load('Nursery.mat');
Ranges=max(Database.Samples')+1;
SamplesTrain=Database.Samples;
SamplesTest=Database.Samples;



Model=TrainQDSOM(SamplesTrain,Ranges,NumRowsMap,NumColsMap,NumSteps,RootNode);


Winners2 = WinnerQDSOMMEX(Model,SamplesTest);
[Winners,LogProbabilities] = WinnerQDSOMMEX(Model,SamplesTest);

FontSize=16;
for NdxSample=[2 9]
    MyData=reshape(LogProbabilities(:,NdxSample),NumRowsMap,NumColsMap);
    MyData=exp(MyData);
    MyData=MyData/sum(MyData(:));
    figure
    surf(MyData)
    xlabel('Column index','FontSize',FontSize)
    ylabel('Row index','FontSize',FontSize)
    zlabel('P(q_{tj} | {\bf x}_t)','FontSize',FontSize)
    set(gca,'FontSize',FontSize)
    set(gca,'XTick',1:NumColsMap)
    set(gca,'YTick',1:NumRowsMap)
    [WinRow,WinCol]=ind2sub([NumRowsMap NumColsMap],Winners(NdxSample));
    title(sprintf('Winner unit is at row %d, column %d',WinRow,WinCol),'FontSize',FontSize);
end
    



