function [NeuronCoords,DistTopol]=CreateCairoGrid(NumRows,NumCols,Toroidal)
% Cairo pentagonal grid
% For this grid, both grid dimensions should be even. This way all the
% triangles and all the squares are closed.

NumNeurons=NumRows*NumCols;
BigNeuronCoords=zeros(2,2*NumRows,2*NumCols);
DistTopol=cell(NumRows,NumCols);

% Height is the height of the triangles
SideLength=1;
Height=sqrt(0.75*(SideLength^2));
% Generate the neuron coords
for NdxRow=0:(2*NumRows-1)   
    if mod(NdxRow,2)==0
        PreviousValue=-1;
    else
        PreviousValue=-0.5;
    end
    for NdxCol=0:(2*NumCols-1)
        switch mod(NdxCol+3*mod(NdxRow,2),4)
            case 0
                Delta=1;
                BigNeuronCoords(2,NdxRow+1,NdxCol+1)=(0.5+Height)*NdxRow;
            case 1
                Delta=Height;
                BigNeuronCoords(2,NdxRow+1,NdxCol+1)=(0.5+Height)*NdxRow+0.5;
            case 2
                Delta=0;
                BigNeuronCoords(2,NdxRow+1,NdxCol+1)=(0.5+Height)*NdxRow-0.5;
            case 3
                Delta=Height;
                BigNeuronCoords(2,NdxRow+1,NdxCol+1)=(0.5+Height)*NdxRow;
        end        
        BigNeuronCoords(1,NdxRow+1,NdxCol+1)=...
            PreviousValue+Delta;        
        PreviousValue=BigNeuronCoords(1,NdxRow+1,NdxCol+1);
    end    
end

NeuronCoords=BigNeuronCoords(:,1:NumRows,1:NumCols);

if Toroidal
    for NdxRow=1:NumRows
        for NdxCol=1:NumCols
            NdxNeurons=sub2ind([2*NumRows 2*NumCols],[NdxRow NdxRow+NumRows NdxRow NdxRow+NumRows],...
                [NdxCol NdxCol NdxCol+NumCols NdxCol+NumCols]);
            DistTopol{NdxRow,NdxCol}=inf*ones(1,NumNeurons);
            for NdxTry=1:4
                DistTopol{NdxRow,NdxCol}=min(DistTopol{NdxRow,NdxCol},...
                    sqrt(sum((repmat(BigNeuronCoords(:,NdxNeurons(NdxTry)),1,NumNeurons)-NeuronCoords(:,:)).^2,1)));
            end
        end
    end
else
    for NdxRow=1:NumRows
        for NdxCol=1:NumCols
            NdxNeuro=sub2ind([NumRows NumCols],NdxRow,NdxCol);
            DistTopol{NdxRow,NdxCol}=sqrt(sum((repmat(NeuronCoords(:,NdxNeuro),1,NumNeurons)-NeuronCoords(:,:)).^2,1));
        end
    end
end

