function [NeuronCoords,DistTopol]=CreatePrismaticGrid(NumRows,NumCols,Toroidal)
% Prismatic pentagonal grid

NumNeurons=NumRows*NumCols;
BigNeuronCoords=zeros(2,2*NumRows,2*NumCols);
DistTopol=cell(NumRows,NumCols);

% Height is the height of the triangles
SideLength=1;
Height=sqrt(0.75*(SideLength^2));
% Generate the neuron coords
PreviousRowCoord=-Height;
for NdxRow=0:(2*NumRows-1)
    if mod(NdxRow,2)==0
        BigNeuronCoords(1,NdxRow+1,:)=PreviousRowCoord+Height;
    else
        BigNeuronCoords(1,NdxRow+1,:)=PreviousRowCoord+1;
    end
    PreviousRowCoord=BigNeuronCoords(1,NdxRow+1,1);
    for NdxCol=0:(2*NumCols-1)        
        if mod(floor(NdxRow/2),2)==0
            BigNeuronCoords(2,NdxRow+1,NdxCol+1)=NdxCol;
        else
            BigNeuronCoords(2,NdxRow+1,NdxCol+1)=NdxCol+0.5;
        end
    end
end

NeuronCoords=BigNeuronCoords(:,1:NumRows,1:NumCols);

if Toroidal
    for NdxRow=1:NumRows
        for NdxCol=1:NumCols
            NdxNeurons=sub2ind([2*NumRows 2*NumCols],[NdxRow NdxRow+NumRows NdxRow NdxRow+NumRows],...
                [NdxCol NdxCol NdxCol+NumCols NdxCol+NumCols]);
            DistTopol{NdxRow,NdxCol}=inf*ones(1,NumNeurons);
            for NdxTry=1:4
                DistTopol{NdxRow,NdxCol}=min(DistTopol{NdxRow,NdxCol},...
                    sqrt(sum((repmat(BigNeuronCoords(:,NdxNeurons(NdxTry)),1,NumNeurons)-NeuronCoords(:,:)).^2,1)));
            end
        end
    end
else
    for NdxRow=1:NumRows
        for NdxCol=1:NumCols
            NdxNeuro=sub2ind([NumRows NumCols],NdxRow,NdxCol);
            DistTopol{NdxRow,NdxCol}=sqrt(sum((repmat(NeuronCoords(:,NdxNeuro),1,NumNeurons)-NeuronCoords(:,:)).^2,1));
        end
    end
end

