function [NeuronCoords,DistTopol]=CreateTriGrid(NumRows,NumCols,Toroidal)
% Triangular grid

NumNeurons=NumRows*NumCols;
BigNeuronCoords=zeros(2,2*NumRows,2*NumCols);
DistTopol=cell(NumRows,NumCols);

% The apothem is the distance from the center of the hexagon to one of its
% sides
HexRadius=1;
Apothem=sqrt(0.75*(HexRadius^2));
Delta=sqrt(HexRadius^2-Apothem^2);
% Generate the neuron coords
for NdxRow=0:(2*NumRows-1)
    BigNeuronCoords(1,NdxRow+1,:)=Apothem*NdxRow;
    for NdxCol=0:(2*NumCols-1)        
        if mod(NdxCol,2)==0
            BigNeuronCoords(2,NdxRow+1,NdxCol+1)=1.5*NdxCol;
        else
            BigNeuronCoords(2,NdxRow+1,NdxCol+1)=1.5*NdxCol+0.5*((-1)^NdxRow);
        end
        if mod(NdxRow,2)==1
            BigNeuronCoords(2,NdxRow+1,NdxCol+1)=BigNeuronCoords(2,NdxRow+1,NdxCol+1)+Delta;
        end
    end
end

NeuronCoords=BigNeuronCoords(:,1:NumRows,1:NumCols);

if Toroidal
    for NdxRow=1:NumRows
        for NdxCol=1:NumCols
            NdxNeurons=sub2ind([2*NumRows 2*NumCols],[NdxRow NdxRow+NumRows NdxRow NdxRow+NumRows],...
                [NdxCol NdxCol NdxCol+NumCols NdxCol+NumCols]);
            DistTopol{NdxRow,NdxCol}=inf*ones(1,NumNeurons);
            for NdxTry=1:4
                DistTopol{NdxRow,NdxCol}=min(DistTopol{NdxRow,NdxCol},...
                    sqrt(sum((repmat(BigNeuronCoords(:,NdxNeurons(NdxTry)),1,NumNeurons)-NeuronCoords(:,:)).^2,1)));
            end
        end
    end
else
    for NdxRow=1:NumRows
        for NdxCol=1:NumCols
            NdxNeuro=sub2ind([NumRows NumCols],NdxRow,NdxCol);
            DistTopol{NdxRow,NdxCol}=sqrt(sum((repmat(NeuronCoords(:,NdxNeuro),1,NumNeurons)-NeuronCoords(:,:)).^2,1));
        end
    end
end

