% Gamma parameter demo
clear all
close all
LineSpec={'-b','-r','-k','-g','-m'};
NumRows=100;
NumCols=NumRows;
Toroidal=true;

ListGridTypes={'Square','Hex','Tri','Prismatic','Cairo'};

figure;
for NdxGrid=1:numel(ListGridTypes)
    MyGridType=ListGridTypes{NdxGrid};
   
    switch MyGridType
        case 'Square'
            [NeuronCoords,DistTopol]=CreateSquareGrid(NumRows,NumCols,Toroidal);
        case 'Hex'
            [NeuronCoords,DistTopol]=CreateHexGrid(NumRows,NumCols,Toroidal);
        case 'Tri'
            [NeuronCoords,DistTopol]=CreateTriGrid(NumRows,NumCols,Toroidal);
        case 'Cairo'
            [NeuronCoords,DistTopol]=CreateCairoGrid(NumRows,NumCols,Toroidal);
        case 'Prismatic'
            [NeuronCoords,DistTopol]=CreatePrismaticGrid(NumRows,NumCols,Toroidal);
    end
    
    D=DistTopol{1};
    MaxD=max(D); %normalize so max distance in the lattice is equal to 1
    D=(1/MaxD).*D;
    howmanyinball=zeros(1,NumRows);
    beta=zeros(1,NumRows);
    for i=1:NumRows        
        whoinball=D(find(D<(i/NumRows)));
        howmanyinball(i)=size(whoinball,2);
        denominator=howmanyinball(i);
        numerator=sum(exp(-(whoinball.^2)));
        beta(i)=numerator/denominator;
    end
    howmanyinball=(10/(NumRows*NumCols)).*howmanyinball;
    
    Handles(NdxGrid)=plot(howmanyinball,beta,LineSpec{NdxGrid},'LineWidth',1);
    hold on
    xlabel('Thousands of vertices');
    ylabel('Parameter \gamma');
    
end
legend(Handles,ListGridTypes,'Location','SouthWest');
uistack(Handles(1),'top');


