% Dual tilings demo
clear all
NumRows=8;
NumCols=8;
Toroidal=0;

ListGridTypes={'Square','Hex','Tri','Cairo','Prismatic'};
%ColorList={[1 1 0.5],[0.5 1 1],[1 0.5 1],[1 0.5 0.5],[1 0.5 0.5],[0.5 0.5 1],[0.5 0.5 0.5],[0.5 1 0.5]};
ColorList=0.5+0.5*autumn(NumRows*NumCols+4);


for NdxGrid=1:numel(ListGridTypes)
    MyGridType=ListGridTypes{NdxGrid}
    switch MyGridType
        case 'Square'
            [NeuronCoords,DistTopol]=CreateSquareGrid(NumRows,NumCols,Toroidal);
        case 'Hex'
            [NeuronCoords,DistTopol]=CreateHexGrid(NumRows,NumCols,Toroidal);
        case 'Tri'
            [NeuronCoords,DistTopol]=CreateTriGrid(NumRows,NumCols,Toroidal);
        case 'Cairo'
            [NeuronCoords,DistTopol]=CreateCairoGrid(NumRows,NumCols,Toroidal);
        case 'Prismatic'
            [NeuronCoords,DistTopol]=CreatePrismaticGrid(NumRows,NumCols,Toroidal);
    end
    Model.NeuronCoords=NeuronCoords;
    Model.DistTopol=DistTopol;
    Model.Prototypes=NeuronCoords;
    Model.NumRowsMap=NumRows;
    Model.NumColsMap=NumCols;    
    [Handle]=PlotSOFM2Dalt(Model);
    hold on
    %title(MyGridType);
    
    
    Centers=[NeuronCoords(:,:)' ; -1e5 0 ; 0 -1e5 ; 1e5 0 ; 0 1e5 ];
    % Old syntax:
    %DelaunayTriangulation=DelaunayTri(Centers);
    DelaunayTriangulation=delaunayTriangulation(Centers);
    [Vertices,Regions]=voronoiDiagram(DelaunayTriangulation);
    for NdxRegion=1:numel(Regions)
         MyVertices=Vertices(Regions{NdxRegion},:);
         Handle=fill(MyVertices(:,1),MyVertices(:,2),ColorList(mod(1817*NdxRegion+23,size(ColorList,1))+1,:));
         %fill(MyVertices(:,1),MyVertices(:,2),'r');
         uistack(Handle,'bottom');
         set(Handle,'EdgeColor',ColorList(mod(1817*NdxRegion+23,size(ColorList,1))+1,:));
         hold on
    end
    Limits=minmax(NeuronCoords(:,:));
    Limits(:,1)=Limits(:,1)-0.5;
    Limits(:,2)=Limits(:,2)+0.5;
    axis equal    
    axis([Limits(1,1) Limits(1,2) Limits(2,1) Limits(2,2)]); 
    axis off
    
    hold off
   
         
    reshape(DistTopol{1},[NumRows NumCols])
end

