% Grid energy theory demo
clear all
LineSpec={'-b','-r','-k','-g','-m'};
NumRows=16;
NumCols=16;
Toroidal=0;

ListGridTypes={'Square','Hex','Tri','Prismatic','Cairo'};

figure;
for NdxGrid=1:numel(ListGridTypes)
    MyGridType=ListGridTypes{NdxGrid};
    
    for NdxRadius=1:101
        MeanRadius=(NdxRadius-1)*sqrt(0.5*NumRows*NumCols)/100;
        [ThisGridEnergy,ThisLatticeDistances]=GridEnergy(MyGridType,NumRows,NumCols,Toroidal,MeanRadius);    
        MyGridEnergy(NdxGrid,NdxRadius)=ThisGridEnergy;
    end    
    LatticeDistances{NdxGrid}=ThisLatticeDistances;
    Handles(NdxGrid)=plot((0:100)*sqrt(0.5*NumRows*NumCols)/100,MyGridEnergy(NdxGrid,:),LineSpec{NdxGrid});
    hold on
    xlabel('Neighborhood radius');
    ylabel('Grid energy');
end
legend(Handles,ListGridTypes,'Location','SouthEast');


