% Simple demo with the uniform distribution over the unit square
clear all

Samples=rand(2,10000);

% These parameters should be optimized for best performance
Parameters.NumSteps=100000;
Parameters.NumRowsMap=6;
Parameters.NumColsMap=6;
Parameters.InitialLearningRate=0.4;
Parameters.MaxRadius=(Parameters.NumRowsMap+Parameters.NumRowsMap)/8;
Parameters.ConvergenceLearningRate=0.01;
Parameters.ConvergenceRadius=1;


%Parameters.Topology='Square';
%Parameters.Topology='Hex';
%Parameters.Topology='Tri';
Parameters.Topology='Cairo';
%Parameters.Topology='Prismatic';
Parameters.Toroidal=0;
tic
SOFMModel=TrainSOFM(Samples,Parameters);
toc
[WinnersSOFM,ErrorsSOFM,TopologyErrorSOFM,OffendingSamplesSOFM,TiedRanksSOFM]=CompetitionSOFMMEX(SOFMModel,Samples);
MSESOFM2D=mean(ErrorsSOFM)
TopologyErrorSOFM
[Handle]=PlotSOFM2D(SOFMModel)
MTRSOFM=mean(TiedRanksSOFM)
