% Simple demo with the uniform distribution over the unit cube
clear all

Samples=rand(3,10000);

% These parameters should be optimized for best performance
Parameters.NumSteps=100000;
Parameters.NumRowsMap=8;
Parameters.NumColsMap=7;
Parameters.InitialLearningRate=0.4;
Parameters.MaxRadius=(Parameters.NumRowsMap+Parameters.NumRowsMap)/8;
Parameters.ConvergenceLearningRate=0.01;
Parameters.ConvergenceRadius=1;


% Original SOFM, 2D
%Parameters.Topology='Square';
%Parameters.Topology='Hex';
%Parameters.Topology='Tri';
Parameters.Topology='Cairo';
%Parameters.Topology='Prismatic';
Parameters.Toroidal=0;
tic
SOFM=TrainSOFM(Samples,Parameters);
toc
[WinnersSOFM,ErrorsSOFM,TopologyErrorSOFM,OffendingSamplesSOFM]=CompetitionSOFM(SOFM,Samples);
MSESOFM=mean(ErrorsSOFM)
TopologyErrorSOFM
[Handle]=PlotSOFM3D(SOFM,Samples(:,1:100:end),OffendingSamplesSOFM(1:100:end));
