% Color quantization demo
clear all

% Load the image
OriginalImage=double(imread('OriginalImages/Lena.png'))/255;
Samples=reshape(OriginalImage,[size(OriginalImage,1)*size(OriginalImage,2) 3])';

% These parameters should be optimized for best performance
Parameters.NumSteps=100000;
Parameters.NumRowsMap=8;
Parameters.NumColsMap=8;
Parameters.InitialLearningRate=0.4;
Parameters.MaxRadius=(Parameters.NumRowsMap+Parameters.NumRowsMap)/16;
Parameters.ConvergenceLearningRate=0.1;
Parameters.ConvergenceRadius=0.1;


%Parameters.Topology='Square';
%Parameters.Topology='Hex';
Parameters.Topology='Tri';
%Parameters.Topology='Cairo';
%Parameters.Topology='Prismatic';
Parameters.Toroidal=0;
tic
SOFMModel=TrainSOFM(Samples,Parameters);
toc
[WinnersSOFM,ErrorsSOFM,TopologyErrorSOFM,OffendingSamplesSOFM]=CompetitionSOFM(SOFMModel,Samples);
MSESOFM=mean(ErrorsSOFM)
TopologyErrorSOFM
[Handle]=PlotSOFM3D(SOFMModel,Samples(:,1:1000:end),OffendingSamplesSOFM(1:1000:end));

% Plot the reconstructed image
WinningPrototypesSOFM=SOFMModel.Prototypes(:,WinnersSOFM);
ReconstructedImage=reshape(WinningPrototypesSOFM',size(OriginalImage));
figure
imshow(ReconstructedImage);

% Plot the prototype colors
MyModelGrid=SOFMModel;
MyModelGrid.Prototypes=SOFMModel.NeuronCoords;
Centers=[SOFMModel.NeuronCoords(:,:)' ; -1e6 0 ; 0 -1e6 ; 1e6 0 ; 0 1e6 ];
% Old syntax
%DelaunayTriangulation=DelaunayTri(Centers);
DelaunayTriangulation=delaunayTriangulation(Centers);
[Vertices,Regions]=voronoiDiagram(DelaunayTriangulation);
figure;
for NdxRegion=1:numel(Regions)
    MyVertices=Vertices(Regions{NdxRegion},:);
    RegionCenter=mean(MyVertices,1)';
    MyNeuron=CompetitionSOFMMEX(MyModelGrid,RegionCenter);
    MyColor=SOFMModel.Prototypes(:,MyNeuron);
    Handle=fill(MyVertices(:,1),MyVertices(:,2),MyColor');
    set(Handle,'EdgeColor',MyColor');
    %fill(MyVertices(:,1),MyVertices(:,2),'r');
    uistack(Handle,'bottom');
    hold on
end
Limits=minmax(SOFMModel.NeuronCoords(:,:));
Limits(:,1)=Limits(:,1)-0.5;
Limits(:,2)=Limits(:,2)+0.5;
axis equal
axis([Limits(1,1) Limits(1,2) Limits(2,1) Limits(2,2)]);
axis off
hold off