function [Energy,LatticeDistances]=GridEnergy(GridType,NumRows,NumCols,Toroidal,NeighborhoodRadius)
% Compute the grid energy of a SOFM, given the neighborhood radius of
% the learning process

switch GridType
    case 'Square'
        [NeuronCoords,DistTopol]=CreateSquareGrid(NumRows,NumCols,Toroidal);
    case 'Hex'
        [NeuronCoords,DistTopol]=CreateHexGrid(NumRows,NumCols,Toroidal);
    case 'Tri'
        [NeuronCoords,DistTopol]=CreateTriGrid(NumRows,NumCols,Toroidal);
    case 'Cairo'
        [NeuronCoords,DistTopol]=CreateCairoGrid(NumRows,NumCols,Toroidal);
    case 'Prismatic'
        [NeuronCoords,DistTopol]=CreatePrismaticGrid(NumRows,NumCols,Toroidal);
end

Model.NeuronCoords=NeuronCoords;
Model.DistTopol=DistTopol;
Model.Prototypes=NeuronCoords;
Model.NumRowsMap=NumRows;
Model.NumColsMap=NumCols;
    
% Number of units of the map
NumUnits=Model.NumRowsMap*Model.NumColsMap;

% Mean neighborhood radius
%MeanRadius=0.25*Parameters.MaxRadius+0.5*Parameters.ConvergenceRadius;

% Normalize the neuron coordinates to lie in the unit square
Minima=min(Model.NeuronCoords(:,:),[],2);
Maxima=max(Model.NeuronCoords(:,:),[],2);
for NdxDim=1:2
    Model.NeuronCoords(NdxDim,:,:)=(Model.NeuronCoords(NdxDim,:,:)-Minima(NdxDim))/...
        (Maxima(NdxDim)-Minima(NdxDim));
end

% Compute the grid energy neuron by neuron
Energy=0;
LatticeDistances=zeros(NumUnits,NumUnits);
for NdxUnit=1:NumUnits
    % Get normalized neighborhood coefficients
    NeighborhoodCoeffs=exp(-Model.DistTopol{NdxUnit}/(NeighborhoodRadius^2));
    NeighborhoodCoeffs=NeighborhoodCoeffs/sum(NeighborhoodCoeffs);

    % Compute squared lattice distances
    SquareDists=sum((repmat(Model.NeuronCoords(:,NdxUnit),1,NumUnits)-Model.NeuronCoords(:,:)).^2,1);
    
    % Accumulate the grid energy
    Energy=Energy+sum(NeighborhoodCoeffs.*SquareDists);
    
    % Store lattice distances
    LatticeDistances(NdxUnit,:)=sqrt(SquareDists);
end

% CenterUnit=[ceil(Model.NumRowsMap/2) ceil(Model.NumColsMap/2)];
% NdxCenterUnit=sub2ind([Model.NumRowsMap Model.NumColsMap],CenterUnit(1),CenterUnit(2));
% LambdaDist.Values=exp(-Model.DistTopol{CenterUnit(1),CenterUnit(2)}/(MeanRadius^2));
% LambdaDist.Values=LambdaDist.Values/sum(LambdaDist.Values);
% LambdaDist.Mean=mean(LambdaDist.Values);
% LambdaDist.Std=std(LambdaDist.Values);
% 
% PositionDist.Values=repmat(Model.NeuronCoords(:,NdxCenterUnit),1,NumUnits)-Model.NeuronCoords(:,:);
% PositionDist.Directions=atan(PositionDist.Values(1,:)./PositionDist.Values(2,:));