% Plot a SOFM in a 2D space
function [Handle]=PlotSOFM2D(Model)


Handle=figure;
hold on

% Plot the connections
for NdxNeuron1=1:Model.NumRowsMap*Model.NumColsMap
    NdxNeighbors=find((Model.DistTopol{NdxNeuron1}<1.05) & (Model.DistTopol{NdxNeuron1}>0.95));
    for NdxNeuron2=NdxNeighbors
        LineaX=[Model.Prototypes(1,NdxNeuron1) Model.Prototypes(1,NdxNeuron2)];
        LineaY=[Model.Prototypes(2,NdxNeuron1) Model.Prototypes(2,NdxNeuron2)];        
        plot(LineaX,LineaY,'-b','LineWidth',1.5);
    end
end


% Plot the neurons
for NdxFila=1:Model.NumRowsMap
    for NdxCol=1:Model.NumColsMap
        plot(Model.Prototypes(1,NdxFila,NdxCol),Model.Prototypes(2,NdxFila,NdxCol),'or','MarkerFaceColor','r');
    end
end
