% Plot a SOFM in a 2D space, connections only
function [Handle]=PlotSOFM2Dalt(Model)

Handle=figure;
hold on

% Plot the connections
for NdxNeuron1=1:Model.NumRowsMap*Model.NumColsMap
    NdxNeighbors=find((Model.DistTopol{NdxNeuron1}<1.05) & (Model.DistTopol{NdxNeuron1}>0.95));
    for NdxNeuron2=NdxNeighbors
        LineaX=[Model.Prototypes(1,NdxNeuron1) Model.Prototypes(1,NdxNeuron2)];
        LineaY=[Model.Prototypes(2,NdxNeuron1) Model.Prototypes(2,NdxNeuron2)];        
        plot(LineaX,LineaY,'-k','LineWidth',1);
    end
end

