% Plot a SOFM in a 3D space 
function [Handle]=PlotSOFM3D(Model,Samples,OffendingSamples)

[Dimension NumSamples]=size(Samples);
NumNeurons=Model.NumColsMap*Model.NumRowsMap;
% Initialize along the two first principal directions
Options.disp=0;
Mu=mean(Samples,2);
if NumSamples>Dimension
    C=cov(Samples');
    if Dimension>3
        Model.GlobalMu=Mu;
        [Uq Lambdaq]=eigs(C,3,'LM',Options);
        Model.UqT=Uq';
    end   
else
    % We use the eigenface trick here
    SamplesZeroMean=Samples-repmat(Mu,1,NumSamples); 
    L=SamplesZeroMean'*SamplesZeroMean;
    [Lvectors Lvalues]=eigs(L,3,'LM',Options);
    Uq=normc(SamplesZeroMean*Lvectors);
    Model.UqT=Uq';
    Model.GlobalMu=Mu;
    Lambdaq=Lvalues/(NumSamples-1);  
end


if Model.Dimension>3
    PrototypesIni=Uq'*(Model.Prototypes(:,:)-repmat(Mu,[1 size(PrototypesIni,2)]));
    SamplesPCA=Uq'*(Samples-repmat(Mu,[1 size(Samples,2)]));
else
    Prototypes=Model.Prototypes(:,:);
    SamplesPCA=Samples;
end



Handle=figure;
hold on


% Paint some samples
plot3(SamplesPCA(1,OffendingSamples==1),SamplesPCA(2,OffendingSamples==1),SamplesPCA(3,OffendingSamples==1),'.k','Color',[0.5 0 0]);
plot3(SamplesPCA(1,OffendingSamples==0),SamplesPCA(2,OffendingSamples==0),SamplesPCA(3,OffendingSamples==0),'.k','Color',[1 0.5 0]);

% Paint the connections
for NdxNeuron1=1:Model.NumRowsMap*Model.NumColsMap
    NdxNeighbors=find((Model.DistTopol{NdxNeuron1}<1.05) & (Model.DistTopol{NdxNeuron1}>0.95));
    for NdxNeuron2=NdxNeighbors
         LineaX=[Prototypes(1,NdxNeuron1) Prototypes(1,NdxNeuron2)];
        LineaY=[Prototypes(2,NdxNeuron1) Prototypes(2,NdxNeuron2)];  
        LineaZ=[Prototypes(3,NdxNeuron1) Prototypes(3,NdxNeuron2)];  
        plot3(LineaX,LineaY,LineaZ,'-b','LineWidth',1);
    end
end




% Plot the neurons
for NdxNeuron1=1:Model.NumRowsMap*Model.NumColsMap
    plot3(Prototypes(1,NdxNeuron1),Prototypes(2,NdxNeuron1),Prototypes(3,NdxNeuron1),'or');

end
