/*
 * Decompiled with CFR 0.152.
 */
package debugger;

import debugger.Function;
import debugger.Operation;
import debugger.Program;
import debugger.Statement;
import debugger.Variable;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.Stack;
import sourceCode.SourceCode;

public class Assignment
extends Statement {
    private String name;
    private BigInteger value;
    private String operator;
    private TypeAssignment classification;
    private Operation operation;
    private Function function1;
    private Function function2;
    private boolean doubleAssignment;
    private BigInteger doubleAssignmentValue;
    private int doubleAssignmentStartLine;
    private int returnLine;
    private int steps;
    private Stack<Function> functions = new Stack();

    public Assignment(int line, String name, BigInteger value, Program currentProgram, SourceCode code, LinkedList<Program> programs, Stack<Statement> stack) {
        this.classification = TypeAssignment.TYPE1;
        this.sourceCode = code;
        this.programs = programs;
        this.runLine = this.startLine = line;
        this.name = name;
        this.value = value;
        this.currentProgram = currentProgram;
        this.runStack = stack;
        this.runStack.push(this);
        this.doubleAssignment = false;
        this.type = Statement.InstructionType.ASSIGNMENT;
    }

    public Assignment(int line, String name, Function function, Program currentProgram, SourceCode code, LinkedList<Program> programs, Stack<Statement> stack) {
        this.classification = TypeAssignment.TYPE2;
        this.sourceCode = code;
        this.programs = programs;
        this.runLine = this.startLine = line;
        this.name = name;
        this.function1 = function;
        this.currentProgram = currentProgram;
        this.runStack = stack;
        this.runStack.push(this);
        this.doubleAssignment = false;
        this.type = Statement.InstructionType.ASSIGNMENT;
    }

    public Assignment(int line, String name, Operation function, Program currentProgram, SourceCode code, LinkedList<Program> programs, Stack<Statement> stack) {
        this.classification = TypeAssignment.TYPE3;
        this.runLine = this.startLine = line;
        this.programs = programs;
        this.sourceCode = code;
        this.name = name;
        this.operation = function;
        this.value = this.operation.evaluate();
        this.currentProgram = currentProgram;
        this.runStack = stack;
        this.runStack.push(this);
        this.doubleAssignment = false;
        this.type = Statement.InstructionType.ASSIGNMENT;
    }

    public Assignment(int line, String name, Function function, BigInteger value, String op, Program currentProgram, SourceCode code, LinkedList<Program> programs, Stack<Statement> stack) {
        this.classification = TypeAssignment.TYPE4;
        this.runLine = this.startLine = line;
        this.programs = programs;
        this.sourceCode = code;
        this.name = name;
        this.function1 = function;
        this.operator = op;
        this.value = value;
        this.currentProgram = currentProgram;
        this.runStack = stack;
        this.runStack.push(this);
        this.doubleAssignment = false;
        this.type = Statement.InstructionType.ASSIGNMENT;
    }

    public Assignment(int runLine, String name, BigInteger value, Function function, String operation, Program currentProgram, SourceCode sourceCode, LinkedList<Program> programs, Stack<Statement> stack) {
        this.classification = TypeAssignment.TYPE5;
        this.runLine = this.startLine = runLine;
        this.programs = programs;
        this.sourceCode = sourceCode;
        this.name = name;
        this.function2 = function;
        this.operator = operation;
        this.value = value;
        this.currentProgram = currentProgram;
        this.runStack = stack;
        this.runStack.push(this);
        this.doubleAssignment = false;
        this.type = Statement.InstructionType.ASSIGNMENT;
    }

    public Assignment(int line, String name, Function function1, Function function2, String operator, Program currentProgram, SourceCode sourceCode, LinkedList<Program> programs, Stack<Statement> runStack) {
        this.classification = TypeAssignment.TYPE6;
        this.runLine = this.startLine = line;
        this.programs = programs;
        this.sourceCode = sourceCode;
        this.name = name;
        this.currentProgram = currentProgram;
        this.function1 = function1;
        this.function2 = function2;
        this.operator = operator;
        this.runStack = runStack;
        this.runStack.push(this);
        this.doubleAssignment = true;
        this.type = Statement.InstructionType.ASSIGNMENT;
    }

    public void executeAssignment() {
        if (!this.currentProgram.isVariable(this.name)) {
            this.currentProgram.addAndGetVariable(this.name, new BigInteger("0"), false);
        }
        this.currentProgram.setVariable(this.name, this.value);
    }

    public String getVariableName() {
        return this.name;
    }

    public int getSteps() {
        return this.steps;
    }

    public int run(Program.StepType step) {
        block25: {
            block24: {
                if (!this.functions.isEmpty()) break block24;
                switch (this.classification) {
                    case TYPE1: 
                    case TYPE3: {
                        this.executeAssignment();
                        this.runStack.pop();
                        this.returnLine = this.runLine + 1;
                        break;
                    }
                    case TYPE2: {
                        if (step == Program.StepType.STEP_OVER) {
                            this.function1.run();
                            this.steps = this.function1.getSteps();
                            this.value = this.function1.getResult();
                            this.executeAssignment();
                            this.function1.endExecution();
                            this.runStack.pop();
                            this.returnLine = this.startLine + 1;
                            break;
                        }
                        if (step == Program.StepType.STEP_INTO) {
                            this.functions.push(this.function1);
                            this.returnLine = this.function1.getRunLine();
                            break;
                        }
                        break block25;
                    }
                    case TYPE4: {
                        if (step == Program.StepType.STEP_OVER) {
                            this.function1.run();
                            this.steps = this.function1.getSteps();
                            Variable temp2 = new Variable("temp1", this.function1.getResult(), true);
                            Variable temp1 = new Variable("temp2", this.value, true);
                            Operation operation = new Operation(temp1, temp2, this.operator);
                            this.value = operation.evaluate();
                            this.executeAssignment();
                            this.function1.endExecution();
                            this.runStack.pop();
                            this.returnLine = this.startLine + 1;
                            break;
                        }
                        this.functions.push(this.function1);
                        this.returnLine = this.function1.getRunLine();
                        break;
                    }
                    case TYPE5: {
                        if (step == Program.StepType.STEP_OVER) {
                            this.function2.run();
                            this.steps = this.function2.getSteps();
                            Variable varTemp1 = new Variable("temp1", this.value, true);
                            Variable varTemp2 = new Variable("temp2", this.function2.getResult(), true);
                            Operation operacionAux = new Operation(varTemp1, varTemp2, this.operator);
                            this.value = operacionAux.evaluate();
                            this.executeAssignment();
                            this.function2.endExecution();
                            this.runStack.pop();
                            this.returnLine = this.startLine + 1;
                            break;
                        }
                        this.functions.push(this.function2);
                        this.returnLine = this.function2.getRunLine();
                        break;
                    }
                    case TYPE6: {
                        if (step == Program.StepType.STEP_OVER) {
                            this.function1.run();
                            this.function2.run();
                            this.steps = this.function2.getSteps() + this.function1.getSteps();
                            Variable varTemp1 = new Variable("temp1", this.function1.getResult(), true);
                            Variable varTemp2 = new Variable("temp2", this.function2.getResult(), true);
                            Operation operacionAux = new Operation(varTemp1, varTemp2, this.operator);
                            this.value = operacionAux.evaluate();
                            this.executeAssignment();
                            this.function1.endExecution();
                            this.function2.endExecution();
                            this.runStack.pop();
                            this.returnLine = this.startLine + 1;
                            break;
                        }
                        this.functions.push(this.function1);
                        this.functions.push(this.function2);
                        this.returnLine = this.function2.getRunLine();
                        this.doubleAssignmentStartLine = this.function1.getRunLine();
                    }
                }
                break block25;
            }
            Function functionAux = this.functions.pop();
            if (step == Program.StepType.STEP_OUT) {
                functionAux.run();
                this.value = functionAux.getResult();
                this.executeAssignment();
                functionAux.endExecution();
                if (this.doubleAssignment) {
                    this.doubleAssignment = false;
                    this.returnLine = this.startLine;
                } else {
                    this.runStack.pop();
                    this.returnLine = this.startLine + 1;
                }
            } else {
                this.functions.push(functionAux);
                this.runLine = functionAux.getRunLine();
                int numEndLine = functionAux.getEndLine();
                if (this.runLine < numEndLine) {
                    this.runLine = functionAux.step();
                    if (this.runLine == numEndLine + 1) {
                        this.endFunction(functionAux);
                    } else {
                        this.returnLine = this.runLine;
                    }
                } else if (this.runLine == numEndLine) {
                    if (!this.sourceCode.isTokenOd(this.sourceCode.getTokenLine(this.runLine, 1))) {
                        this.runLine = functionAux.step();
                        this.endFunction(functionAux);
                    } else {
                        this.returnLine = this.runLine = functionAux.step();
                    }
                } else {
                    this.endFunction(functionAux);
                }
            }
        }
        return this.returnLine;
    }

    public void endFunction(Function functionAux) {
        if (this.classification == TypeAssignment.TYPE2) {
            this.functions.pop();
            this.value = functionAux.getResult();
            this.executeAssignment();
            functionAux.endExecution();
            this.runStack.pop();
            this.returnLine = this.startLine + 1;
        } else if (this.classification == TypeAssignment.TYPE4 || this.classification == TypeAssignment.TYPE5) {
            functionAux = this.functions.pop();
            Variable aux1 = new Variable("temp1", this.value, true);
            Variable aux2 = new Variable("temp2", functionAux.getResult(), true);
            Operation opAux = new Operation(aux1, aux2, this.operator);
            this.value = opAux.evaluate();
            this.executeAssignment();
            functionAux.endExecution();
            this.runStack.pop();
            this.returnLine = this.startLine + 1;
        } else if (this.doubleAssignment) {
            functionAux = this.functions.pop();
            this.doubleAssignmentValue = functionAux.getResult();
            functionAux.endExecution();
            this.doubleAssignment = false;
            this.returnLine = this.doubleAssignmentStartLine;
        } else {
            functionAux = this.functions.pop();
            Variable aux1 = new Variable("temp1", functionAux.getResult(), true);
            Variable aux2 = new Variable("temp2", this.doubleAssignmentValue, true);
            Operation operationAux = new Operation(aux1, aux2, this.operator);
            this.value = operationAux.evaluate();
            this.executeAssignment();
            functionAux.endExecution();
            this.runStack.pop();
            this.returnLine = this.startLine + 1;
        }
    }

    private static enum TypeAssignment {
        TYPE1,
        TYPE2,
        TYPE3,
        TYPE4,
        TYPE5,
        TYPE6;

    }
}

