/*
 * Decompiled with CFR 0.152.
 */
package debugger;

import debugger.Condition;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JCheckBox;

public class BreakpointCond
implements ActionListener {
    private LinkedList<NodeCondition> conditions = new LinkedList();
    private LinkedList<Integer> candidates = new LinkedList();
    private int id = 0;

    public LinkedList<NodeCondition> getNodeConditions() {
        return this.conditions;
    }

    public void addCondition(Condition c) {
        Integer numberId = this.id;
        ++this.id;
        JCheckBox auxCheck = new JCheckBox("", false);
        auxCheck.setActionCommand(numberId.toString());
        auxCheck.addActionListener(this);
        NodeCondition aux = new NodeCondition(c, auxCheck, numberId);
        this.conditions.add(aux);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Integer causante = Integer.parseInt(e.getActionCommand());
        this.candidates.add(causante);
    }

    public boolean isCondition(Condition condition) {
        boolean result = false;
        int i = 0;
        while (i < this.conditions.size()) {
            if (this.conditions.get(i).getCondition().equals(condition)) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    public void removeCondition(int id) {
        boolean end = false;
        Iterator nodes = this.conditions.iterator();
        while (nodes.hasNext() && !end) {
            NodeCondition aux = (NodeCondition)nodes.next();
            if (aux.getId() != id) continue;
            this.conditions.remove(aux);
            end = true;
        }
    }

    public void removeCondition(String name) {
        boolean fin = false;
        Iterator nodes = this.conditions.iterator();
        while (nodes.hasNext() && !fin) {
            NodeCondition aux = (NodeCondition)nodes.next();
            if (!aux.getCondition().getFirstOperatorName().equalsIgnoreCase(name)) continue;
            this.conditions.remove(aux);
            fin = true;
        }
    }

    public void updateConditions() {
        if (!this.conditions.isEmpty()) {
            int i = 0;
            while (i < this.candidates.size()) {
                this.removeCondition(this.candidates.get(i));
                ++i;
            }
            this.candidates = new LinkedList();
        }
    }

    public boolean updateCandidates() {
        boolean result = false;
        if (!this.candidates.isEmpty()) {
            result = true;
        }
        return result;
    }

    public Condition checkConditions(String name) {
        Condition c = null;
        int i = 0;
        while (c == null && i < this.conditions.size()) {
            if (name.equalsIgnoreCase(this.conditions.get(i).getCondition().getFirstOperatorName()) && this.conditions.get(i).getCondition().executeCondition()) {
                c = this.conditions.get(i).getCondition();
            }
            ++i;
        }
        return c;
    }

    public LinkedList<Condition> getConditions() {
        LinkedList<Condition> aux = new LinkedList<Condition>();
        int i = 0;
        while (i < this.conditions.size()) {
            aux.add(this.conditions.get(i).getCondition());
            ++i;
        }
        return aux;
    }

    public void resetConditions() {
        this.conditions = new LinkedList();
        this.candidates = new LinkedList();
        this.id = 0;
    }

    public static class NodeCondition {
        private int id;
        private Condition cond;
        private JCheckBox remove;

        public NodeCondition(Condition c, JCheckBox b, int number) {
            this.cond = c;
            this.remove = b;
            this.id = number;
        }

        public Condition getCondition() {
            return this.cond;
        }

        public int getId() {
            return this.id;
        }

        public JCheckBox selectedBox() {
            return this.remove;
        }
    }
}

