/*
 * Decompiled with CFR 0.152.
 */
package debugger;

import debugger.Program;
import debugger.Variable;

public class Condition {
    private Variable operand1;
    private Variable operand2;
    private Operators operator;
    private Program program;

    public Condition(Variable operand1, Variable operand2, String operator, Program program) {
        this.operand1 = operand1;
        this.operand2 = operand2;
        this.operator = this.getOperator(operator);
        this.program = program;
    }

    public boolean executeCondition() {
        boolean result = false;
        if (!this.operand1.isFinal()) {
            this.operand1.setValue(this.program.getVariable(this.operand1.getName()).getValue());
        }
        if (!this.operand2.isFinal()) {
            this.operand2.setValue(this.program.getVariable(this.operand2.getName()).getValue());
        }
        switch (this.operator) {
            case GREATER: {
                result = this.operand1.getValue().compareTo(this.operand2.getValue()) > 0;
                break;
            }
            case GREATER_OR_EQUALS: {
                result = this.operand1.getValue().compareTo(this.operand2.getValue()) >= 0;
                break;
            }
            case LESS: {
                result = this.operand1.getValue().compareTo(this.operand2.getValue()) < 0;
                break;
            }
            case LESS_OR_EQUALS: {
                result = this.operand1.getValue().compareTo(this.operand2.getValue()) <= 0;
                break;
            }
            case EQUALS: {
                result = this.operand1.getValue().compareTo(this.operand2.getValue()) == 0;
                break;
            }
            case NO_EQUALS: {
                result = this.operand1.getValue().compareTo(this.operand2.getValue()) != 0;
            }
        }
        return result;
    }

    public Operators getOperator(String operator) {
        Operators result = operator.equalsIgnoreCase(">") ? Operators.GREATER : (operator.equalsIgnoreCase(">=") ? Operators.GREATER_OR_EQUALS : (operator.equalsIgnoreCase("<") ? Operators.LESS : (operator.equalsIgnoreCase("<=") ? Operators.LESS_OR_EQUALS : (operator.equalsIgnoreCase("=") ? Operators.EQUALS : Operators.NO_EQUALS))));
        return result;
    }

    public String getFirstOperatorName() {
        return this.operand1.getName();
    }

    public int hashCode() {
        return this.operand1.hashCode() + this.operator.hashCode() + this.operand2.hashCode();
    }

    public boolean equals(Object objeto) {
        return objeto instanceof Condition && ((Condition)objeto).operand1.equals(this.operand1) && ((Condition)objeto).operator.equals((Object)this.operator) && ((Condition)objeto).operand2.equals(this.operand2);
    }

    public String toString() {
        String result = "";
        switch (this.operator) {
            case GREATER: {
                result = String.valueOf(this.operand1.getName()) + "  >  " + this.operand2;
                break;
            }
            case GREATER_OR_EQUALS: {
                result = String.valueOf(this.operand1.getName()) + "  >=  " + this.operand2;
                break;
            }
            case LESS: {
                result = String.valueOf(this.operand1.getName()) + "  <  " + this.operand2;
                break;
            }
            case LESS_OR_EQUALS: {
                result = String.valueOf(this.operand1.getName()) + "  <=  " + this.operand2;
                break;
            }
            case EQUALS: {
                result = String.valueOf(this.operand1.getName()) + "  =  " + this.operand2;
                break;
            }
            case NO_EQUALS: {
                result = String.valueOf(this.operand1.getName()) + "  !=  " + this.operand2;
            }
        }
        return result;
    }

    private static enum Operators {
        GREATER,
        GREATER_OR_EQUALS,
        LESS,
        LESS_OR_EQUALS,
        EQUALS,
        NO_EQUALS;

    }
}

