/*
 * Decompiled with CFR 0.152.
 */
package debugger;

import debugger.Program;
import debugger.ProgramWhile;
import debugger.ProgramWhileA;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SortedMap;
import sourceCode.SourceCode;

public class ContrProgram {
    private SourceCode source = null;
    private LinkedList<Program> programs = new LinkedList();

    public boolean loadSourceCode(File file) {
        this.source = new SourceCode(file);
        return this.source.isSourceCodeError();
    }

    public SortedMap<Integer, String> getSourceCode() {
        return this.source.getSourceCode();
    }

    public String paintSourceCode() {
        return this.source.toString();
    }

    public void loadPrograms() {
        this.programs = new LinkedList();
        int line = 0;
        while (line < this.source.sizeSourceCode()) {
            Program node;
            int end;
            int start;
            if (this.source.isStartProgramLineW(line)) {
                start = line;
                while (line <= this.source.sizeSourceCode() && !this.source.isEndSourceCodeLine(line) && !this.source.isEndProgramLineW(line)) {
                    ++line;
                }
                end = this.source.isEndProgramLineW(line) && line == this.source.sizeSourceCode() ? line : line - 1;
                Integer numInputs = (Integer)this.source.getTokenLine((Integer)Integer.valueOf((int)start), (int)4).value;
                Integer numTotal = (Integer)this.source.getTokenLine((Integer)Integer.valueOf((int)start), (int)6).value;
                node = new ProgramWhile((String)this.source.getTokenLine((Integer)Integer.valueOf((int)start), (int)1).value, start, end, this.source, this.programs, numInputs, numTotal, (String)this.source.getTokenLine((Integer)Integer.valueOf((int)start), (int)8).value);
                this.programs.add(node);
            } else if (this.source.isStartProgramLineWA(line)) {
                start = line;
                while (line <= this.source.sizeSourceCode() && !this.source.isEndSourceCodeLine(line) && !this.source.isEndProgramLineWA(line)) {
                    ++line;
                }
                end = this.source.isEndProgramLineWA(line) && line == this.source.sizeSourceCode() ? line : line - 1;
                node = new ProgramWhileA((String)this.source.getTokenLine((Integer)Integer.valueOf((int)(start - 1)), (int)0).value, start - 1, end, this.source, this.programs);
                this.programs.add(node);
            }
            ++line;
        }
    }

    public boolean programComment() {
        return this.source.isCommentLine();
    }

    public Program getProgram(String name) {
        boolean found = false;
        Iterator st = this.programs.iterator();
        Program result = (Program)st.next();
        while (st.hasNext() && !found) {
            if (result.getProgramName().equalsIgnoreCase(name)) {
                found = true;
                continue;
            }
            result = (Program)st.next();
        }
        if (!found) {
            result = null;
        }
        return result;
    }

    public Program getMainProgram() {
        return this.programs.getFirst();
    }

    public int sizeSourceCode() {
        return this.source.sizeSourceCode();
    }

    public LinkedList<Program> getPrograms() {
        return this.programs;
    }
}

