/*
 * Decompiled with CFR 0.152.
 */
package debugger;

import debugger.Function;
import debugger.Operation;
import debugger.Program;
import debugger.Statement;
import debugger.Variable;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.Stack;
import java_cup.runtime.Symbol;
import sourceCode.SourceCode;

public class DoTimes
extends Statement {
    private BigInteger loopIterations;

    public DoTimes(int line, Program currentProgram, SourceCode sourceCode, LinkedList<Program> programs, Stack<Statement> stack) {
        this.sourceCode = sourceCode;
        this.programs = programs;
        this.runLine = this.startLine = line;
        this.endLine = this.getOdLine(this.startLine + 1);
        this.currentProgram = currentProgram;
        this.runStack = stack;
        this.runStack.push(this);
        this.type = Statement.InstructionType.DOTIMES;
    }

    public BigInteger getLoopIterations() {
        Function function = null;
        Operation operation = null;
        Symbol token = null;
        int index = 0;
        BigInteger iterationNumber = new BigInteger("0");
        String op = "";
        Variable aux1 = null;
        Variable aux2 = null;
        index = 1;
        token = this.sourceCode.getTokenLine(this.startLine, index);
        if (!this.sourceCode.isTokenNum(token)) {
            if (this.currentProgram.isSourceCodeProgram((String)token.value)) {
                function = new Function(this.startLine, this.currentProgram, this.sourceCode, this.programs, this.runStack, (String)token.value);
                function.run();
                iterationNumber = function.getResult();
            } else {
                aux1 = this.currentProgram.getVariable((String)token.value);
                op = (String)this.sourceCode.getTokenLine((Integer)Integer.valueOf((int)this.startLine), (int)(++index)).value;
                token = this.sourceCode.getTokenLine(this.startLine, ++index);
                aux2 = this.sourceCode.isTokenNum(token) ? this.currentProgram.addAndGetVariable("temp2", new BigInteger(((Integer)token.value).toString()), true) : this.currentProgram.getVariable((String)token.value);
                operation = new Operation(aux1, aux2, op);
                iterationNumber = operation.evaluate();
            }
        } else {
            aux1 = this.currentProgram.addAndGetVariable("temp1", new BigInteger(((Integer)token.value).toString()), true);
            op = (String)this.sourceCode.getTokenLine((Integer)Integer.valueOf((int)this.startLine), (int)(++index)).value;
            token = this.sourceCode.getTokenLine(this.startLine, ++index);
            aux2 = this.sourceCode.isTokenNum(token) ? this.currentProgram.addAndGetVariable("temp2", new BigInteger(((Integer)token.value).toString()), true) : this.currentProgram.getVariable((String)token.value);
            operation = new Operation(aux1, aux2, op);
            iterationNumber = operation.evaluate();
        }
        return iterationNumber;
    }

    public int run(Program.StepType step) {
        if (this.runLine == this.startLine) {
            this.loopIterations = this.getLoopIterations();
            ++this.runLine;
        } else if (this.runLine == this.endLine && this.loopIterations.compareTo(BigInteger.ZERO) > 0) {
            this.runLine = this.startLine + 1;
            while (this.currentProgram.isEmptyLine(this.runLine)) {
                ++this.runLine;
            }
            this.loopIterations = this.loopIterations.subtract(BigInteger.ONE);
            if (this.loopIterations.compareTo(BigInteger.ZERO) == 0) {
                this.runLine = this.getOdLine(this.runLine) + 1;
                this.runStack.pop();
            }
        } else if (this.loopIterations.compareTo(BigInteger.ZERO) > 0) {
            this.runLine = this.currentProgram.run(this.runLine, this.runStack, step);
        } else {
            this.runLine = this.getOdLine(this.runLine) + 1;
            this.runStack.pop();
        }
        return this.runLine;
    }
}

