/*
 * Decompiled with CFR 0.152.
 */
package debugger;

import debugger.Program;
import debugger.ProgramWhile;
import debugger.ProgramWhileA;
import debugger.Statement;
import debugger.Variable;
import debuggerExceptions.DebuggerException;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.Stack;
import java_cup.runtime.Symbol;
import sourceCode.SourceCode;

public class Function
extends Statement {
    private LinkedList<BigInteger> inputs;
    private String name;
    private Program associateProgram;
    private Program sourceProgram;
    private int steps;
    private int indexLine;
    private int functionLine;

    public Function(int line, Program currentProgram, SourceCode sourceCode, LinkedList<Program> programs, Stack<Statement> runStack, String name) {
        this.sourceCode = sourceCode;
        this.programs = programs;
        this.functionLine = line;
        this.name = name;
        this.sourceProgram = currentProgram;
        this.setInputs(this.functionLine);
        this.associateProgram = this.sourceProgram.getProgram(name);
        ((ProgramWhileA)this.associateProgram).endDebug();
        this.setInputs();
        System.out.println(this.associateProgram.programsToString());
        this.startLine = this.associateProgram.getStartProgramLine();
        this.runLine = this.associateProgram.getRunLine();
        this.endLine = this.associateProgram.getEndProgramLine();
        this.type = Statement.InstructionType.FUNCTION;
    }

    public String getFunctionName() {
        return this.name;
    }

    public int getLastToken() {
        return this.indexLine;
    }

    public void setInputs(int line) {
        this.inputs = new LinkedList();
        this.indexLine = 0;
        while (!this.sourceCode.isTokenParIz(this.sourceCode.getTokenLine(line, this.indexLine))) {
            ++this.indexLine;
        }
        ++this.indexLine;
        Symbol token = this.sourceCode.getTokenLine(line, this.indexLine);
        while (!this.sourceCode.isTokenParDer(token)) {
            if (this.sourceCode.isTokenNum(token)) {
                this.inputs.add(new BigInteger(token.value.toString()));
            } else if (this.sourceCode.isTokenID(token) || this.sourceCode.isTokenIDWhile(token)) {
                Variable varAux = this.sourceProgram.getVariable((String)token.value);
                this.inputs.add(varAux.getValue());
            }
            ++this.indexLine;
            token = this.sourceCode.getTokenLine(line, this.indexLine);
        }
        for (BigInteger i : this.inputs) {
            System.out.println(i);
        }
    }

    public void setInputs() {
        if (this.associateProgram.isWhileA()) {
            ((ProgramWhileA)this.associateProgram).addInputs(this.associateProgram.getInputVariable(), this.inputs);
        } else {
            ((ProgramWhile)this.associateProgram).addInputs(this.inputs);
        }
    }

    public BigInteger getResult() {
        return this.associateProgram.getProgramOutput();
    }

    public int step() {
        this.associateProgram.step(Program.StepType.STEP_OVER);
        this.runLine = this.associateProgram.getRunLine();
        return this.runLine;
    }

    public void run() {
        boolean end = false;
        boolean breakpointEnd = false;
        while (!breakpointEnd && !end) {
            if (!this.associateProgram.programsStopBPC()) {
                this.associateProgram.checkBreakpoint(this.associateProgram.getRunLine());
                if (!this.associateProgram.programsStopBreakpoint()) {
                    try {
                        end = this.associateProgram.step(Program.StepType.STEP_INTO);
                        continue;
                    }
                    catch (Exception e) {
                        throw new DebuggerException("Error en la ejecuci\u00f3n del programa WHILE");
                    }
                }
                breakpointEnd = true;
                this.sourceProgram.setStateBreakpoint(true);
                continue;
            }
            this.associateProgram.nextLineRunAfterBPC();
            this.sourceProgram.setStopBPC(true);
            breakpointEnd = true;
        }
    }

    public int getSteps() {
        return this.steps;
    }

    @Override
    public int getRunLine() {
        return this.associateProgram.getRunLine();
    }

    public int getEndLine() {
        return this.associateProgram.getEndProgramLine();
    }

    public void endExecution() {
        if (this.associateProgram.isWhileA()) {
            ((ProgramWhileA)this.associateProgram).endDebug();
        } else {
            ((ProgramWhile)this.associateProgram).endDebug();
        }
    }

    public boolean isEnd() {
        return this.associateProgram.isFinished();
    }

    public boolean isStopBPC() {
        return this.associateProgram.programsStopBPC();
    }
}

